<template>
    <div>
        <div style="width:600px;float: left; margin: 10px;">
            <el-input v-model="query" placeholder="请输入查询条件" style="width :300px;float: left;"></el-input>
            <el-button type="primary" @click="search">查询</el-button>
            <el-button type="primary" @click="handleAdd">新增</el-button>
        </div>
        <el-table v-loading="loading" :data="tableData" stripe border style="width: 99%;">
            <el-table-column v-for="item in tableProperty" :key="item.id" :prop="item.tableProp" :label="item.tableLabel" :width="item.tableWidth" v-if="item.attr1==='0'">
            </el-table-column>
            <el-table-column label="操作">
                <template slot-scope="scope">
                    <el-button size="mini" @click="handleEdit(scope.row)">编辑</el-button>
                    <el-button size="mini" type="danger" @click="handleDelete(scope.row.id)">删除</el-button>
                </template>
            </el-table-column>
        </el-table>
        <el-pagination @size-change="handleSizeChange" @current-change="handleCurrentChange" :current-page="currentPage"
                       :page-sizes="pageSizes" :page-size="pageSize" layout="total, sizes, prev, pager, next, jumper" :total="totalRows">
        </el-pagination>

        <el-dialog title="操作" :visible.sync="dialogVisible" width="500px">
            <el-form :model="${modelNameFirstLower}" label-position="right" label-width="80px">
<#list list as ms>
                <el-form-item label="${ms.tableLabel}">
                    <el-input v-model="${modelNameFirstLower}.${ms.tableProp}" placeholder=""></el-input>
                </el-form-item>
</#list>
    <el-form-item>
        <el-button type="success" @click="handleSave">保存</el-button>
        <el-button @click="handleCancelSave">取消</el-button>
    </el-form-item>
            </el-form>
        </el-dialog>


    </div>
</template>
<script>
    import axios from '@/axios';
    export default {
        data() {
            return {
                tableData: [],
                tableProperty: [],
                currentPage: 1,
                totalRows: 0,
                pageSizes: [10, 20, 30, 40],
                pageSize: 10,
                query:'',
        ${modelNameFirstLower}: {
<#list list as ms>
                ${ms.tableProp}: '',
</#list>
                },
                loading: true,
                dialogVisible: false,
            }
        },
        methods: {
            //查询table数据
            getTableData() {
                var url = '${modelName}/query.do'
                var param = {
                    page: this.currentPage,
                    rows: this.pageSize
                }
                axios.get(url, param).then(response => {
                    if (response.data.code == '0') {
                    this.tableData = response.data.data.list
                    this.totalRows = response.data.data.total
                } else {
                    this.$message({
                        type: 'error',
                        message: '操作失败!' + response.data.msg
                    });
                }
                this.loading = false
            });
            },
            //查询table列
            getTableProperty() {
                //console.log("获取table数据getTableData")
                var url = 'CodeMachine/queryTableProperty.do'
                var param = {
                    bussinessName:'${dbTableName}'
                }
                axios.get(url, param).then(response => {
                    this.tableProperty = response.data
            });
            },

            // 修改每页行数
            handleSizeChange(val) {
                this.pageSize = val
                this.getTableData()
            },
            // 修改当前页事件
            handleCurrentChange(val) {
                this.currentPage = val
                this.getTableData()
            },
            //新增按钮事件
            handleAdd() {
                this.dialogVisible = true
                this.${modelNameFirstLower} = {
<#list list as ms>
            ${ms.tableProp}: '',
</#list>
                }
            },
            // 编辑按钮事件
            handleEdit(row) {
                this.dialogVisible = true
                this.${modelNameFirstLower} = row

            },
            // 删除按钮事件
            handleDelete(id) {
                this.$confirm('此操作将删除该数据, 是否继续?', '提示', {
                    confirmButtonText: '确定',
                    cancelButtonText: '取消',
                    type: 'warning'
                }).then(() => {
                    var url = '${modelName}/remove.do'
                    var param = {
                        id: id
                    }
             axios.post(url, param).then(response => {
                    if (response.data.code == '0') {
                    this.$message({
                        type: 'success',
                        message: '删除成功!',
                    });
                    this.getTableData()
                } else {
                    this.$message({
                        type: 'error',
                        message: '删除失败!' + response.data.msg
                    });

                }
            });
            }).catch(() => {
                    this.$message({
                    type: 'info',
                    message: '已取消删除'
                });
            });
            },
            //保存取消按钮事件   关闭编辑对话框
            handleCancelSave(row) {
                this.dialogVisible = false
            },
            //保存按钮事件
            handleSave(row) {
                var url = '${modelName}/save.do'
        var json = JSON.stringify(this.${modelNameFirstLower})
                var param = {
                    json: json
                }
                axios.post(url, param).then(response => {
                    if (response.data.code == '0') {
            this.$message({
                type: 'success',
                message: '操作成功!',
            });
            this.getTableData()
            this.dialogVisible = false
        } else {
            this.$message({
                type: 'error',
                message: '操作失败!' + response.data.msg
            });
        }
            });
            },

            // 查询按钮事件
            search() {
                this.getTableData()
            }
        },
        mounted() {
            this.getTableData()
            this.getTableProperty()
        }
    }
</script>
