package ${packageName}.controller.${moduleName};

import ${packageName}.service.${moduleName}.${modelName}Service;
import com.alibaba.fastjson.JSON;
import com.th.demo.model.system.ResponseCodeMsg;
import com.th.demo.model.system.ResultJSON;
import com.th.demo.model.system.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletRequest;

@RestController
@RequestMapping(value = "/${modelName}")
public class ${modelName}Controller {

@Autowired
private ${modelName}Service ${modelNameFirstLower}Service;

@RequestMapping(value = "/query.do")
    public String query(int page,
                        int rows,
                        HttpServletRequest request) {
        String result = "";
        String userId = (String) request.getAttribute("userId");
        try {
            result = ${modelNameFirstLower}Service.query(page, rows);
        } catch (Exception ex) {
            result = JSON.toJSONString(new ResultJSON(ResponseCodeMsg.CODE_EX, ex.getMessage(), null));
            ex.printStackTrace();
        } finally {
            return result;
        }

    }



 @RequestMapping(value = "/save.do", method = RequestMethod.POST)
    public String save(String json,
                       HttpServletRequest request) {
        String result = "";
        String userId = (String) request.getAttribute("userId");
        try {
            result =${modelNameFirstLower}Service.save(json, userId);
        } catch (Exception ex) {
            result = JSON.toJSONString(new ResultJSON(ResponseCodeMsg.CODE_EX, ex.getMessage(), null));
            ex.printStackTrace();
        } finally {
            return result;
        }
    }

 @RequestMapping(value = "/remove.do", method = RequestMethod.POST)
    public String remove(String id,
                         HttpServletRequest request) {
        String result = "";
        String userId = (String) request.getAttribute("userId");
        try {
            result = ${modelNameFirstLower}Service.remove(id, userId);
        } catch (Exception ex) {
            result = JSON.toJSONString(new ResultJSON(ResponseCodeMsg.CODE_EX, ex.getMessage(), null));
            ex.printStackTrace();
        } finally {
            return result;
        }
    }
}
