/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.console.res;

import com.bstek.ureport.console.ServletAction;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ResourceLoaderServletAction
implements ServletAction,
ApplicationContextAware {
    public static final String URL = "/res";
    private ApplicationContext applicationContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = req.getContextPath() + "/ureport" + URL;
        String uri = req.getRequestURI();
        String resPath = uri.substring(path.length() + 1);
        String p = "classpath:" + resPath;
        if (p.endsWith(".js")) {
            resp.setContentType("text/javascript");
        } else if (p.endsWith(".css")) {
            resp.setContentType("text/css");
        } else if (p.endsWith(".png")) {
            resp.setContentType("image/png");
        } else if (p.endsWith(".jpg")) {
            resp.setContentType("image/jpeg");
        } else if (p.endsWith(".svg")) {
            resp.setContentType("image/svg+xml");
        } else {
            resp.setContentType("application/octet-stream");
        }
        InputStream input = this.applicationContext.getResource(p).getInputStream();
        ServletOutputStream output = resp.getOutputStream();
        try {
            IOUtils.copy((InputStream)input, (OutputStream)output);
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
            IOUtils.closeQuietly((OutputStream)output);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public String url() {
        return URL;
    }
}

