/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt.internal.org.bouncycastle.pqc.asn1;

import com.auth0.jwt.internal.org.bouncycastle.asn1.ASN1EncodableVector;
import com.auth0.jwt.internal.org.bouncycastle.asn1.ASN1Integer;
import com.auth0.jwt.internal.org.bouncycastle.asn1.ASN1Object;
import com.auth0.jwt.internal.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.auth0.jwt.internal.org.bouncycastle.asn1.ASN1OctetString;
import com.auth0.jwt.internal.org.bouncycastle.asn1.ASN1Primitive;
import com.auth0.jwt.internal.org.bouncycastle.asn1.ASN1Sequence;
import com.auth0.jwt.internal.org.bouncycastle.asn1.DEROctetString;
import com.auth0.jwt.internal.org.bouncycastle.asn1.DERSequence;
import com.auth0.jwt.internal.org.bouncycastle.pqc.math.linearalgebra.GF2Matrix;
import java.math.BigInteger;

public class McEliecePublicKey
extends ASN1Object {
    private ASN1ObjectIdentifier oid;
    private int n;
    private int t;
    private byte[] matrixG;

    public McEliecePublicKey(ASN1ObjectIdentifier aSN1ObjectIdentifier, int n, int n2, GF2Matrix gF2Matrix) {
        this.oid = aSN1ObjectIdentifier;
        this.n = n;
        this.t = n2;
        this.matrixG = gF2Matrix.getEncoded();
    }

    private McEliecePublicKey(ASN1Sequence aSN1Sequence) {
        this.oid = (ASN1ObjectIdentifier)aSN1Sequence.getObjectAt(0);
        BigInteger bigInteger = ((ASN1Integer)aSN1Sequence.getObjectAt(1)).getValue();
        this.n = bigInteger.intValue();
        BigInteger bigInteger2 = ((ASN1Integer)aSN1Sequence.getObjectAt(2)).getValue();
        this.t = bigInteger2.intValue();
        this.matrixG = ((ASN1OctetString)aSN1Sequence.getObjectAt(3)).getOctets();
    }

    public ASN1ObjectIdentifier getOID() {
        return this.oid;
    }

    public int getN() {
        return this.n;
    }

    public int getT() {
        return this.t;
    }

    public GF2Matrix getG() {
        return new GF2Matrix(this.matrixG);
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.oid);
        aSN1EncodableVector.add(new ASN1Integer(this.n));
        aSN1EncodableVector.add(new ASN1Integer(this.t));
        aSN1EncodableVector.add(new DEROctetString(this.matrixG));
        return new DERSequence(aSN1EncodableVector);
    }

    public static McEliecePublicKey getInstance(Object object) {
        if (object instanceof McEliecePublicKey) {
            return (McEliecePublicKey)object;
        }
        if (object != null) {
            return new McEliecePublicKey(ASN1Sequence.getInstance(object));
        }
        return null;
    }
}

