/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt.internal.org.bouncycastle.jcajce.provider.symmetric;

import com.auth0.jwt.internal.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.auth0.jwt.internal.org.bouncycastle.asn1.ASN1Primitive;
import com.auth0.jwt.internal.org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.auth0.jwt.internal.org.bouncycastle.asn1.pkcs.PBKDF2Params;
import com.auth0.jwt.internal.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.auth0.jwt.internal.org.bouncycastle.crypto.CipherParameters;
import com.auth0.jwt.internal.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.auth0.jwt.internal.org.bouncycastle.jcajce.provider.symmetric.util.BCPBEKey;
import com.auth0.jwt.internal.org.bouncycastle.jcajce.provider.symmetric.util.BaseAlgorithmParameters;
import com.auth0.jwt.internal.org.bouncycastle.jcajce.provider.symmetric.util.BaseSecretKeyFactory;
import com.auth0.jwt.internal.org.bouncycastle.jcajce.provider.symmetric.util.PBE;
import com.auth0.jwt.internal.org.bouncycastle.jcajce.provider.util.AlgorithmProvider;
import com.auth0.jwt.internal.org.bouncycastle.jcajce.spec.PBKDF2KeySpec;
import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class PBEPBKDF2 {
    private PBEPBKDF2() {
    }

    public static class AlgParams
    extends BaseAlgorithmParameters {
        PBKDF2Params params;

        protected byte[] engineGetEncoded() {
            try {
                return this.params.getEncoded("DER");
            }
            catch (IOException iOException) {
                throw new RuntimeException("Oooops! " + iOException.toString());
            }
        }

        protected byte[] engineGetEncoded(String string) {
            if (this.isASN1FormatString(string)) {
                return this.engineGetEncoded();
            }
            return null;
        }

        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
            if (clazz == PBEParameterSpec.class) {
                return new PBEParameterSpec(this.params.getSalt(), this.params.getIterationCount().intValue());
            }
            throw new InvalidParameterSpecException("unknown parameter spec passed to PBKDF2 PBE parameters object.");
        }

        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
            if (!(algorithmParameterSpec instanceof PBEParameterSpec)) {
                throw new InvalidParameterSpecException("PBEParameterSpec required to initialise a PBKDF2 PBE parameters algorithm parameters object");
            }
            PBEParameterSpec pBEParameterSpec = (PBEParameterSpec)algorithmParameterSpec;
            this.params = new PBKDF2Params(pBEParameterSpec.getSalt(), pBEParameterSpec.getIterationCount());
        }

        protected void engineInit(byte[] byArray) throws IOException {
            this.params = PBKDF2Params.getInstance(ASN1Primitive.fromByteArray(byArray));
        }

        protected void engineInit(byte[] byArray, String string) throws IOException {
            if (this.isASN1FormatString(string)) {
                this.engineInit(byArray);
                return;
            }
            throw new IOException("Unknown parameters format in PBKDF2 parameters object");
        }

        protected String engineToString() {
            return "PBKDF2 Parameters";
        }
    }

    public static class BasePBKDF2
    extends BaseSecretKeyFactory {
        private int scheme;

        public BasePBKDF2(String string, int n) {
            super(string, PKCSObjectIdentifiers.id_PBKDF2);
            this.scheme = n;
        }

        protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof PBEKeySpec) {
                PBEKeySpec pBEKeySpec = (PBEKeySpec)keySpec;
                if (pBEKeySpec.getSalt() == null) {
                    throw new InvalidKeySpecException("missing required salt");
                }
                if (pBEKeySpec.getIterationCount() <= 0) {
                    throw new InvalidKeySpecException("positive iteration count required: " + pBEKeySpec.getIterationCount());
                }
                if (pBEKeySpec.getKeyLength() <= 0) {
                    throw new InvalidKeySpecException("positive key length required: " + pBEKeySpec.getKeyLength());
                }
                if (pBEKeySpec.getPassword().length == 0) {
                    throw new IllegalArgumentException("password empty");
                }
                if (pBEKeySpec instanceof PBKDF2KeySpec) {
                    PBKDF2KeySpec pBKDF2KeySpec = (PBKDF2KeySpec)pBEKeySpec;
                    int n = this.getDigestCode(pBKDF2KeySpec.getPrf().getAlgorithm());
                    int n2 = pBEKeySpec.getKeyLength();
                    int n3 = -1;
                    CipherParameters cipherParameters = PBE.Util.makePBEMacParameters(pBEKeySpec, this.scheme, n, n2);
                    return new BCPBEKey(this.algName, this.algOid, this.scheme, n, n2, n3, pBEKeySpec, cipherParameters);
                }
                int n = 1;
                int n4 = pBEKeySpec.getKeyLength();
                int n5 = -1;
                CipherParameters cipherParameters = PBE.Util.makePBEMacParameters(pBEKeySpec, this.scheme, n, n4);
                return new BCPBEKey(this.algName, this.algOid, this.scheme, n, n4, n5, pBEKeySpec, cipherParameters);
            }
            throw new InvalidKeySpecException("Invalid KeySpec");
        }

        private int getDigestCode(ASN1ObjectIdentifier aSN1ObjectIdentifier) throws InvalidKeySpecException {
            if (aSN1ObjectIdentifier.equals(CryptoProObjectIdentifiers.gostR3411Hmac)) {
                return 6;
            }
            if (aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.id_hmacWithSHA1)) {
                return 1;
            }
            throw new InvalidKeySpecException("Invalid KeySpec: unknown PRF algorithm " + aSN1ObjectIdentifier);
        }
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = PBEPBKDF2.class.getName();

        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("AlgorithmParameters.PBKDF2", PREFIX + "$AlgParams");
            configurableProvider.addAlgorithm("Alg.Alias.AlgorithmParameters." + PKCSObjectIdentifiers.id_PBKDF2, "PBKDF2");
            configurableProvider.addAlgorithm("SecretKeyFactory.PBKDF2", PREFIX + "$PBKDF2withUTF8");
            configurableProvider.addAlgorithm("Alg.Alias.SecretKeyFactory." + PKCSObjectIdentifiers.id_PBKDF2, "PBKDF2");
        }
    }

    public static class PBKDF2withUTF8
    extends BasePBKDF2 {
        public PBKDF2withUTF8() {
            super("PBKDF2", 5);
        }
    }
}

