/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt.internal.org.bouncycastle.crypto.util;

import com.auth0.jwt.internal.org.bouncycastle.asn1.ASN1Encodable;
import com.auth0.jwt.internal.org.bouncycastle.asn1.ASN1InputStream;
import com.auth0.jwt.internal.org.bouncycastle.asn1.ASN1Integer;
import com.auth0.jwt.internal.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.auth0.jwt.internal.org.bouncycastle.asn1.ASN1OctetString;
import com.auth0.jwt.internal.org.bouncycastle.asn1.ASN1Primitive;
import com.auth0.jwt.internal.org.bouncycastle.asn1.DEROctetString;
import com.auth0.jwt.internal.org.bouncycastle.asn1.oiw.ElGamalParameter;
import com.auth0.jwt.internal.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.auth0.jwt.internal.org.bouncycastle.asn1.pkcs.DHParameter;
import com.auth0.jwt.internal.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.auth0.jwt.internal.org.bouncycastle.asn1.pkcs.RSAPublicKey;
import com.auth0.jwt.internal.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.auth0.jwt.internal.org.bouncycastle.asn1.x509.DSAParameter;
import com.auth0.jwt.internal.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.auth0.jwt.internal.org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import com.auth0.jwt.internal.org.bouncycastle.asn1.x9.DHDomainParameters;
import com.auth0.jwt.internal.org.bouncycastle.asn1.x9.DHPublicKey;
import com.auth0.jwt.internal.org.bouncycastle.asn1.x9.DHValidationParms;
import com.auth0.jwt.internal.org.bouncycastle.asn1.x9.ECNamedCurveTable;
import com.auth0.jwt.internal.org.bouncycastle.asn1.x9.X962Parameters;
import com.auth0.jwt.internal.org.bouncycastle.asn1.x9.X9ECParameters;
import com.auth0.jwt.internal.org.bouncycastle.asn1.x9.X9ECPoint;
import com.auth0.jwt.internal.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.auth0.jwt.internal.org.bouncycastle.crypto.ec.CustomNamedCurves;
import com.auth0.jwt.internal.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.auth0.jwt.internal.org.bouncycastle.crypto.params.DHParameters;
import com.auth0.jwt.internal.org.bouncycastle.crypto.params.DHPublicKeyParameters;
import com.auth0.jwt.internal.org.bouncycastle.crypto.params.DHValidationParameters;
import com.auth0.jwt.internal.org.bouncycastle.crypto.params.DSAParameters;
import com.auth0.jwt.internal.org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import com.auth0.jwt.internal.org.bouncycastle.crypto.params.ECDomainParameters;
import com.auth0.jwt.internal.org.bouncycastle.crypto.params.ECNamedDomainParameters;
import com.auth0.jwt.internal.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.auth0.jwt.internal.org.bouncycastle.crypto.params.ElGamalParameters;
import com.auth0.jwt.internal.org.bouncycastle.crypto.params.ElGamalPublicKeyParameters;
import com.auth0.jwt.internal.org.bouncycastle.crypto.params.RSAKeyParameters;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class PublicKeyFactory {
    public static AsymmetricKeyParameter createKey(byte[] byArray) throws IOException {
        return PublicKeyFactory.createKey(SubjectPublicKeyInfo.getInstance(ASN1Primitive.fromByteArray(byArray)));
    }

    public static AsymmetricKeyParameter createKey(InputStream inputStream) throws IOException {
        return PublicKeyFactory.createKey(SubjectPublicKeyInfo.getInstance(new ASN1InputStream(inputStream).readObject()));
    }

    public static AsymmetricKeyParameter createKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        AlgorithmIdentifier algorithmIdentifier = subjectPublicKeyInfo.getAlgorithm();
        if (algorithmIdentifier.getAlgorithm().equals(PKCSObjectIdentifiers.rsaEncryption) || algorithmIdentifier.getAlgorithm().equals(X509ObjectIdentifiers.id_ea_rsa)) {
            RSAPublicKey rSAPublicKey = RSAPublicKey.getInstance(subjectPublicKeyInfo.parsePublicKey());
            return new RSAKeyParameters(false, rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
        }
        if (algorithmIdentifier.getAlgorithm().equals(X9ObjectIdentifiers.dhpublicnumber)) {
            DHPublicKey dHPublicKey = DHPublicKey.getInstance(subjectPublicKeyInfo.parsePublicKey());
            BigInteger bigInteger = dHPublicKey.getY().getValue();
            DHDomainParameters dHDomainParameters = DHDomainParameters.getInstance(algorithmIdentifier.getParameters());
            BigInteger bigInteger2 = dHDomainParameters.getP().getValue();
            BigInteger bigInteger3 = dHDomainParameters.getG().getValue();
            BigInteger bigInteger4 = dHDomainParameters.getQ().getValue();
            BigInteger bigInteger5 = null;
            if (dHDomainParameters.getJ() != null) {
                bigInteger5 = dHDomainParameters.getJ().getValue();
            }
            DHValidationParameters dHValidationParameters = null;
            DHValidationParms dHValidationParms = dHDomainParameters.getValidationParms();
            if (dHValidationParms != null) {
                byte[] byArray = dHValidationParms.getSeed().getBytes();
                BigInteger bigInteger6 = dHValidationParms.getPgenCounter().getValue();
                dHValidationParameters = new DHValidationParameters(byArray, bigInteger6.intValue());
            }
            return new DHPublicKeyParameters(bigInteger, new DHParameters(bigInteger2, bigInteger3, bigInteger4, bigInteger5, dHValidationParameters));
        }
        if (algorithmIdentifier.getAlgorithm().equals(PKCSObjectIdentifiers.dhKeyAgreement)) {
            DHParameter dHParameter = DHParameter.getInstance(algorithmIdentifier.getParameters());
            ASN1Integer aSN1Integer = (ASN1Integer)subjectPublicKeyInfo.parsePublicKey();
            BigInteger bigInteger = dHParameter.getL();
            int n = bigInteger == null ? 0 : bigInteger.intValue();
            DHParameters dHParameters = new DHParameters(dHParameter.getP(), dHParameter.getG(), null, n);
            return new DHPublicKeyParameters(aSN1Integer.getValue(), dHParameters);
        }
        if (algorithmIdentifier.getAlgorithm().equals(OIWObjectIdentifiers.elGamalAlgorithm)) {
            ElGamalParameter elGamalParameter = ElGamalParameter.getInstance(algorithmIdentifier.getParameters());
            ASN1Integer aSN1Integer = (ASN1Integer)subjectPublicKeyInfo.parsePublicKey();
            return new ElGamalPublicKeyParameters(aSN1Integer.getValue(), new ElGamalParameters(elGamalParameter.getP(), elGamalParameter.getG()));
        }
        if (algorithmIdentifier.getAlgorithm().equals(X9ObjectIdentifiers.id_dsa) || algorithmIdentifier.getAlgorithm().equals(OIWObjectIdentifiers.dsaWithSHA1)) {
            ASN1Integer aSN1Integer = (ASN1Integer)subjectPublicKeyInfo.parsePublicKey();
            ASN1Encodable aSN1Encodable = algorithmIdentifier.getParameters();
            DSAParameters dSAParameters = null;
            if (aSN1Encodable != null) {
                DSAParameter dSAParameter = DSAParameter.getInstance(aSN1Encodable.toASN1Primitive());
                dSAParameters = new DSAParameters(dSAParameter.getP(), dSAParameter.getQ(), dSAParameter.getG());
            }
            return new DSAPublicKeyParameters(aSN1Integer.getValue(), dSAParameters);
        }
        if (algorithmIdentifier.getAlgorithm().equals(X9ObjectIdentifiers.id_ecPublicKey)) {
            ECDomainParameters eCDomainParameters;
            X9ECParameters x9ECParameters;
            ASN1Primitive aSN1Primitive;
            X962Parameters x962Parameters = X962Parameters.getInstance(algorithmIdentifier.getParameters());
            if (x962Parameters.isNamedCurve()) {
                aSN1Primitive = (ASN1ObjectIdentifier)x962Parameters.getParameters();
                x9ECParameters = CustomNamedCurves.getByOID(aSN1Primitive);
                if (x9ECParameters == null) {
                    x9ECParameters = ECNamedCurveTable.getByOID(aSN1Primitive);
                }
                eCDomainParameters = new ECNamedDomainParameters((ASN1ObjectIdentifier)aSN1Primitive, x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed());
            } else {
                x9ECParameters = X9ECParameters.getInstance(x962Parameters.getParameters());
                eCDomainParameters = new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed());
            }
            aSN1Primitive = new DEROctetString(subjectPublicKeyInfo.getPublicKeyData().getBytes());
            X9ECPoint x9ECPoint = new X9ECPoint(x9ECParameters.getCurve(), (ASN1OctetString)aSN1Primitive);
            return new ECPublicKeyParameters(x9ECPoint.getPoint(), eCDomainParameters);
        }
        throw new RuntimeException("algorithm identifier in key not recognised");
    }
}

