/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt.internal.org.bouncycastle.crypto.tls;

import com.auth0.jwt.internal.org.bouncycastle.crypto.tls.AbstractTlsClient;
import com.auth0.jwt.internal.org.bouncycastle.crypto.tls.DefaultTlsCipherFactory;
import com.auth0.jwt.internal.org.bouncycastle.crypto.tls.DefaultTlsSRPGroupVerifier;
import com.auth0.jwt.internal.org.bouncycastle.crypto.tls.TlsAuthentication;
import com.auth0.jwt.internal.org.bouncycastle.crypto.tls.TlsCipher;
import com.auth0.jwt.internal.org.bouncycastle.crypto.tls.TlsCipherFactory;
import com.auth0.jwt.internal.org.bouncycastle.crypto.tls.TlsExtensionsUtils;
import com.auth0.jwt.internal.org.bouncycastle.crypto.tls.TlsFatalAlert;
import com.auth0.jwt.internal.org.bouncycastle.crypto.tls.TlsKeyExchange;
import com.auth0.jwt.internal.org.bouncycastle.crypto.tls.TlsSRPGroupVerifier;
import com.auth0.jwt.internal.org.bouncycastle.crypto.tls.TlsSRPKeyExchange;
import com.auth0.jwt.internal.org.bouncycastle.crypto.tls.TlsSRPUtils;
import com.auth0.jwt.internal.org.bouncycastle.crypto.tls.TlsUtils;
import com.auth0.jwt.internal.org.bouncycastle.util.Arrays;
import java.io.IOException;
import java.util.Hashtable;

public class SRPTlsClient
extends AbstractTlsClient {
    protected TlsSRPGroupVerifier groupVerifier;
    protected byte[] identity;
    protected byte[] password;

    public SRPTlsClient(byte[] byArray, byte[] byArray2) {
        this(new DefaultTlsCipherFactory(), new DefaultTlsSRPGroupVerifier(), byArray, byArray2);
    }

    public SRPTlsClient(TlsCipherFactory tlsCipherFactory, byte[] byArray, byte[] byArray2) {
        this(tlsCipherFactory, new DefaultTlsSRPGroupVerifier(), byArray, byArray2);
    }

    public SRPTlsClient(TlsCipherFactory tlsCipherFactory, TlsSRPGroupVerifier tlsSRPGroupVerifier, byte[] byArray, byte[] byArray2) {
        super(tlsCipherFactory);
        this.groupVerifier = tlsSRPGroupVerifier;
        this.identity = Arrays.clone(byArray);
        this.password = Arrays.clone(byArray2);
    }

    protected boolean requireSRPServerExtension() {
        return false;
    }

    public int[] getCipherSuites() {
        return new int[]{49182};
    }

    public Hashtable getClientExtensions() throws IOException {
        Hashtable hashtable = TlsExtensionsUtils.ensureExtensionsInitialised(super.getClientExtensions());
        TlsSRPUtils.addSRPExtension(hashtable, this.identity);
        return hashtable;
    }

    public void processServerExtensions(Hashtable hashtable) throws IOException {
        if (!TlsUtils.hasExpectedEmptyExtensionData(hashtable, TlsSRPUtils.EXT_SRP, (short)47) && this.requireSRPServerExtension()) {
            throw new TlsFatalAlert(47);
        }
        super.processServerExtensions(hashtable);
    }

    public TlsKeyExchange getKeyExchange() throws IOException {
        switch (this.selectedCipherSuite) {
            case 49178: 
            case 49181: 
            case 49184: {
                return this.createSRPKeyExchange(21);
            }
            case 49179: 
            case 49182: 
            case 49185: {
                return this.createSRPKeyExchange(23);
            }
            case 49180: 
            case 49183: 
            case 49186: {
                return this.createSRPKeyExchange(22);
            }
        }
        throw new TlsFatalAlert(80);
    }

    public TlsAuthentication getAuthentication() throws IOException {
        throw new TlsFatalAlert(80);
    }

    public TlsCipher getCipher() throws IOException {
        switch (this.selectedCipherSuite) {
            case 49178: 
            case 49179: 
            case 49180: {
                return this.cipherFactory.createCipher(this.context, 7, 2);
            }
            case 49181: 
            case 49182: 
            case 49183: {
                return this.cipherFactory.createCipher(this.context, 8, 2);
            }
            case 49184: 
            case 49185: 
            case 49186: {
                return this.cipherFactory.createCipher(this.context, 9, 2);
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createSRPKeyExchange(int n) {
        return new TlsSRPKeyExchange(n, this.supportedSignatureAlgorithms, this.groupVerifier, this.identity, this.password);
    }
}

