/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt.internal.com.fasterxml.jackson.databind.deser.std;

import com.auth0.jwt.internal.com.fasterxml.jackson.core.JsonParser;
import com.auth0.jwt.internal.com.fasterxml.jackson.core.JsonProcessingException;
import com.auth0.jwt.internal.com.fasterxml.jackson.core.JsonToken;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.DeserializationContext;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JacksonStdImpl
public class ClassDeserializer
extends StdScalarDeserializer<Class<?>> {
    public ClassDeserializer() {
        super(Class.class);
    }

    @Override
    public Class<?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken curr = jp.getCurrentToken();
        if (curr == JsonToken.VALUE_STRING) {
            String className = jp.getText().trim();
            try {
                return ctxt.findClass(className);
            }
            catch (Exception e) {
                throw ctxt.instantiationException(this._valueClass, ClassUtil.getRootCause(e));
            }
        }
        throw ctxt.mappingException(this._valueClass, curr);
    }
}

