/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs.client;

import java.io.IOException;
import java.net.URI;
import java.security.Principal;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.util.Assert;
import org.springframework.util.concurrent.SettableListenableFuture;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.sockjs.client.TransportRequest;
import org.springframework.web.socket.sockjs.frame.SockJsFrame;
import org.springframework.web.socket.sockjs.frame.SockJsFrameType;
import org.springframework.web.socket.sockjs.frame.SockJsMessageCodec;

public abstract class AbstractClientSockJsSession
implements WebSocketSession {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final TransportRequest request;
    private final WebSocketHandler webSocketHandler;
    private final SettableListenableFuture<WebSocketSession> connectFuture;
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private volatile State state = State.NEW;
    private volatile CloseStatus closeStatus;

    protected AbstractClientSockJsSession(TransportRequest request, WebSocketHandler handler, SettableListenableFuture<WebSocketSession> connectFuture) {
        Assert.notNull((Object)request, (String)"'request' is required");
        Assert.notNull((Object)handler, (String)"'handler' is required");
        Assert.notNull(connectFuture, (String)"'connectFuture' is required");
        this.request = request;
        this.webSocketHandler = handler;
        this.connectFuture = connectFuture;
    }

    @Override
    public String getId() {
        return this.request.getSockJsUrlInfo().getSessionId();
    }

    @Override
    public URI getUri() {
        return this.request.getSockJsUrlInfo().getSockJsUrl();
    }

    @Override
    public HttpHeaders getHandshakeHeaders() {
        return this.request.getHandshakeHeaders();
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public Principal getPrincipal() {
        return this.request.getUser();
    }

    public SockJsMessageCodec getMessageCodec() {
        return this.request.getMessageCodec();
    }

    public WebSocketHandler getWebSocketHandler() {
        return this.webSocketHandler;
    }

    Runnable getTimeoutTask() {
        return new Runnable(){

            @Override
            public void run() {
                AbstractClientSockJsSession.this.closeInternal(new CloseStatus(2007, "Transport timed out"));
            }
        };
    }

    @Override
    public boolean isOpen() {
        return State.OPEN.equals((Object)this.state);
    }

    public boolean isDisconnected() {
        return State.CLOSING.equals((Object)this.state) || State.CLOSED.equals((Object)this.state);
    }

    @Override
    public final void sendMessage(WebSocketMessage<?> message) throws IOException {
        Assert.state((boolean)State.OPEN.equals((Object)this.state), (String)(this + " is not open, current state=" + (Object)((Object)this.state)));
        Assert.isInstanceOf(TextMessage.class, message, (String)(this + " supports text messages only."));
        String payload = (String)((TextMessage)message).getPayload();
        payload = this.getMessageCodec().encode(payload);
        payload = payload.substring(1);
        message = new TextMessage(payload);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Sending message " + message + " in " + this));
        }
        this.sendInternal(message);
    }

    protected abstract void sendInternal(TextMessage var1) throws IOException;

    @Override
    public final void close() throws IOException {
        this.close(CloseStatus.NORMAL);
    }

    @Override
    public final void close(CloseStatus status) {
        Assert.isTrue((status != null && this.isUserSetStatus(status) ? 1 : 0) != 0, (String)("Invalid close status: " + status));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Closing session with " + status + " in " + this));
        }
        this.closeInternal(status);
    }

    private boolean isUserSetStatus(CloseStatus status) {
        return status.getCode() == 1000 || status.getCode() >= 3000 && status.getCode() <= 4999;
    }

    protected void closeInternal(CloseStatus status) {
        block4: {
            if (this.state == null) {
                this.logger.warn((Object)"Ignoring close since connect() was never invoked");
                return;
            }
            if (State.CLOSING.equals((Object)this.state) || State.CLOSED.equals((Object)this.state)) {
                this.logger.debug((Object)("Ignoring close (already closing or closed), current state=" + (Object)((Object)this.state)));
                return;
            }
            this.state = State.CLOSING;
            this.closeStatus = status;
            try {
                this.disconnect(status);
            }
            catch (Throwable ex) {
                if (!this.logger.isErrorEnabled()) break block4;
                this.logger.error((Object)("Failed to close " + this), ex);
            }
        }
    }

    protected abstract void disconnect(CloseStatus var1) throws IOException;

    public void handleFrame(String payload) {
        SockJsFrame frame = new SockJsFrame(payload);
        if (SockJsFrameType.OPEN.equals((Object)frame.getType())) {
            this.handleOpenFrame();
        } else if (SockJsFrameType.MESSAGE.equals((Object)frame.getType())) {
            this.handleMessageFrame(frame);
        } else if (SockJsFrameType.CLOSE.equals((Object)frame.getType())) {
            this.handleCloseFrame(frame);
        } else if (SockJsFrameType.HEARTBEAT.equals((Object)frame.getType())) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Received heartbeat in " + this));
            }
        } else {
            throw new IllegalStateException("Unknown SockJS frame type " + frame + " in " + this);
        }
    }

    private void handleOpenFrame() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Processing SockJS open frame in " + this));
        }
        if (State.NEW.equals((Object)this.state)) {
            this.state = State.OPEN;
            try {
                this.webSocketHandler.afterConnectionEstablished(this);
                this.connectFuture.set((Object)this);
            }
            catch (Throwable ex) {
                if (this.logger.isErrorEnabled()) {
                    Class<?> type = this.webSocketHandler.getClass();
                    this.logger.error((Object)(type + ".afterConnectionEstablished threw exception in " + this), ex);
                }
            }
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Open frame received in " + this.getId() + " but we're notconnecting (current state=" + (Object)((Object)this.state) + "). The server might have been restarted and lost track of the session."));
            }
            this.closeInternal(new CloseStatus(1006, "Server lost session"));
        }
    }

    private void handleMessageFrame(SockJsFrame frame) {
        String[] messages;
        if (!this.isOpen()) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error((Object)("Ignoring received message due to state=" + (Object)((Object)this.state) + " in " + this));
            }
            return;
        }
        try {
            messages = this.getMessageCodec().decode(frame.getFrameData());
        }
        catch (IOException ex) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error((Object)("Failed to decode data for SockJS \"message\" frame: " + frame + " in " + this), (Throwable)ex);
            }
            this.closeInternal(CloseStatus.BAD_DATA);
            return;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Processing SockJS message frame " + frame.getContent() + " in " + this));
        }
        for (String message : messages) {
            try {
                if (!this.isOpen()) continue;
                this.webSocketHandler.handleMessage(this, new TextMessage(message));
            }
            catch (Throwable ex) {
                Class<?> type = this.webSocketHandler.getClass();
                this.logger.error((Object)(type + ".handleMessage threw an exception on " + frame + " in " + this), ex);
            }
        }
    }

    private void handleCloseFrame(SockJsFrame frame) {
        CloseStatus closeStatus;
        block4: {
            closeStatus = CloseStatus.NO_STATUS_CODE;
            try {
                String[] data = this.getMessageCodec().decode(frame.getFrameData());
                if (data.length == 2) {
                    closeStatus = new CloseStatus(Integer.valueOf(data[0]), data[1]);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Processing SockJS close frame with " + closeStatus + " in " + this));
                }
            }
            catch (IOException ex) {
                if (!this.logger.isErrorEnabled()) break block4;
                this.logger.error((Object)("Failed to decode data for " + frame + " in " + this), (Throwable)ex);
            }
        }
        this.closeInternal(closeStatus);
    }

    public void handleTransportError(Throwable error) {
        block3: {
            try {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error((Object)("Transport error in " + this), error);
                }
                this.webSocketHandler.handleTransportError(this, error);
            }
            catch (Exception ex) {
                Class<?> type = this.webSocketHandler.getClass();
                if (!this.logger.isErrorEnabled()) break block3;
                this.logger.error((Object)(type + ".handleTransportError threw an exception"), (Throwable)ex);
            }
        }
    }

    public void afterTransportClosed(CloseStatus closeStatus) {
        block3: {
            this.closeStatus = this.closeStatus != null ? this.closeStatus : closeStatus;
            Assert.state((this.closeStatus != null ? 1 : 0) != 0, (String)"CloseStatus not available");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Transport closed with " + this.closeStatus + " in " + this));
            }
            this.state = State.CLOSED;
            try {
                this.webSocketHandler.afterConnectionClosed(this, this.closeStatus);
            }
            catch (Exception ex) {
                if (!this.logger.isErrorEnabled()) break block3;
                Class<?> type = this.webSocketHandler.getClass();
                this.logger.error((Object)(type + ".afterConnectionClosed threw an exception"), (Throwable)ex);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id='" + this.getId() + ", url=" + this.getUri() + "]";
    }

    private static enum State {
        NEW,
        OPEN,
        CLOSING,
        CLOSED;

    }
}

