/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import java.util.Iterator;
import net.sf.jsqlparser.statement.Commit;
import net.sf.jsqlparser.statement.SetStatement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.Statements;
import net.sf.jsqlparser.statement.UseStatement;
import net.sf.jsqlparser.statement.alter.Alter;
import net.sf.jsqlparser.statement.create.index.CreateIndex;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.create.view.AlterView;
import net.sf.jsqlparser.statement.create.view.CreateView;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.drop.Drop;
import net.sf.jsqlparser.statement.execute.Execute;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.merge.Merge;
import net.sf.jsqlparser.statement.replace.Replace;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.statement.truncate.Truncate;
import net.sf.jsqlparser.statement.update.Update;
import net.sf.jsqlparser.statement.upsert.Upsert;
import net.sf.jsqlparser.util.deparser.AlterDeParser;
import net.sf.jsqlparser.util.deparser.AlterViewDeParser;
import net.sf.jsqlparser.util.deparser.CreateIndexDeParser;
import net.sf.jsqlparser.util.deparser.CreateTableDeParser;
import net.sf.jsqlparser.util.deparser.CreateViewDeParser;
import net.sf.jsqlparser.util.deparser.DeleteDeParser;
import net.sf.jsqlparser.util.deparser.DropDeParser;
import net.sf.jsqlparser.util.deparser.ExecuteDeParser;
import net.sf.jsqlparser.util.deparser.ExpressionDeParser;
import net.sf.jsqlparser.util.deparser.InsertDeParser;
import net.sf.jsqlparser.util.deparser.ReplaceDeParser;
import net.sf.jsqlparser.util.deparser.SelectDeParser;
import net.sf.jsqlparser.util.deparser.SetStatementDeParser;
import net.sf.jsqlparser.util.deparser.UpdateDeParser;
import net.sf.jsqlparser.util.deparser.UpsertDeParser;
import net.sf.jsqlparser.util.deparser.UseStatementDeParser;

public class StatementDeParser
implements StatementVisitor {
    private ExpressionDeParser expressionDeParser;
    private SelectDeParser selectDeParser;
    private StringBuilder buffer;

    public StatementDeParser(StringBuilder buffer) {
        this(new ExpressionDeParser(), new SelectDeParser(), buffer);
    }

    public StatementDeParser(ExpressionDeParser expressionDeParser, SelectDeParser selectDeParser, StringBuilder buffer) {
        this.expressionDeParser = expressionDeParser;
        this.selectDeParser = selectDeParser;
        this.buffer = buffer;
    }

    @Override
    public void visit(CreateIndex createIndex) {
        CreateIndexDeParser createIndexDeParser = new CreateIndexDeParser(this.buffer);
        createIndexDeParser.deParse(createIndex);
    }

    @Override
    public void visit(CreateTable createTable) {
        CreateTableDeParser createTableDeParser = new CreateTableDeParser(this.buffer);
        createTableDeParser.deParse(createTable);
    }

    @Override
    public void visit(CreateView createView) {
        CreateViewDeParser createViewDeParser = new CreateViewDeParser(this.buffer);
        createViewDeParser.deParse(createView);
    }

    @Override
    public void visit(AlterView alterView) {
        AlterViewDeParser alterViewDeParser = new AlterViewDeParser(this.buffer);
        alterViewDeParser.deParse(alterView);
    }

    @Override
    public void visit(Delete delete) {
        this.selectDeParser.setBuffer(this.buffer);
        this.expressionDeParser.setSelectVisitor(this.selectDeParser);
        this.expressionDeParser.setBuffer(this.buffer);
        this.selectDeParser.setExpressionVisitor(this.expressionDeParser);
        DeleteDeParser deleteDeParser = new DeleteDeParser(this.expressionDeParser, this.buffer);
        deleteDeParser.deParse(delete);
    }

    @Override
    public void visit(Drop drop) {
        DropDeParser dropDeParser = new DropDeParser(this.buffer);
        dropDeParser.deParse(drop);
    }

    @Override
    public void visit(Insert insert) {
        this.selectDeParser.setBuffer(this.buffer);
        this.expressionDeParser.setSelectVisitor(this.selectDeParser);
        this.expressionDeParser.setBuffer(this.buffer);
        this.selectDeParser.setExpressionVisitor(this.expressionDeParser);
        InsertDeParser insertDeParser = new InsertDeParser(this.expressionDeParser, this.selectDeParser, this.buffer);
        insertDeParser.deParse(insert);
    }

    @Override
    public void visit(Replace replace) {
        this.selectDeParser.setBuffer(this.buffer);
        this.expressionDeParser.setSelectVisitor(this.selectDeParser);
        this.expressionDeParser.setBuffer(this.buffer);
        this.selectDeParser.setExpressionVisitor(this.expressionDeParser);
        ReplaceDeParser replaceDeParser = new ReplaceDeParser(this.expressionDeParser, this.selectDeParser, this.buffer);
        replaceDeParser.deParse(replace);
    }

    @Override
    public void visit(Select select) {
        this.selectDeParser.setBuffer(this.buffer);
        this.expressionDeParser.setSelectVisitor(this.selectDeParser);
        this.expressionDeParser.setBuffer(this.buffer);
        this.selectDeParser.setExpressionVisitor(this.expressionDeParser);
        if (select.getWithItemsList() != null && !select.getWithItemsList().isEmpty()) {
            this.buffer.append("WITH ");
            Iterator<WithItem> iter = select.getWithItemsList().iterator();
            while (iter.hasNext()) {
                WithItem withItem = iter.next();
                withItem.accept(this.selectDeParser);
                if (iter.hasNext()) {
                    this.buffer.append(",");
                }
                this.buffer.append(" ");
            }
        }
        select.getSelectBody().accept(this.selectDeParser);
    }

    @Override
    public void visit(Truncate truncate) {
    }

    @Override
    public void visit(Update update) {
        this.selectDeParser.setBuffer(this.buffer);
        this.expressionDeParser.setSelectVisitor(this.selectDeParser);
        this.expressionDeParser.setBuffer(this.buffer);
        UpdateDeParser updateDeParser = new UpdateDeParser(this.expressionDeParser, this.selectDeParser, this.buffer);
        this.selectDeParser.setExpressionVisitor(this.expressionDeParser);
        updateDeParser.deParse(update);
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuilder buffer) {
        this.buffer = buffer;
    }

    @Override
    public void visit(Alter alter) {
        AlterDeParser alterDeParser = new AlterDeParser(this.buffer);
        alterDeParser.deParse(alter);
    }

    @Override
    public void visit(Statements stmts) {
        stmts.accept(this);
    }

    @Override
    public void visit(Execute execute) {
        this.selectDeParser.setBuffer(this.buffer);
        this.expressionDeParser.setSelectVisitor(this.selectDeParser);
        this.expressionDeParser.setBuffer(this.buffer);
        ExecuteDeParser executeDeParser = new ExecuteDeParser(this.expressionDeParser, this.buffer);
        this.selectDeParser.setExpressionVisitor(this.expressionDeParser);
        executeDeParser.deParse(execute);
    }

    @Override
    public void visit(SetStatement set) {
        this.selectDeParser.setBuffer(this.buffer);
        this.expressionDeParser.setSelectVisitor(this.selectDeParser);
        this.expressionDeParser.setBuffer(this.buffer);
        SetStatementDeParser setStatementDeparser = new SetStatementDeParser(this.expressionDeParser, this.buffer);
        this.selectDeParser.setExpressionVisitor(this.expressionDeParser);
        setStatementDeparser.deParse(set);
    }

    @Override
    public void visit(Merge merge) {
        this.buffer.append(merge.toString());
    }

    @Override
    public void visit(Commit commit) {
        this.buffer.append(commit.toString());
    }

    @Override
    public void visit(Upsert upsert) {
        this.selectDeParser.setBuffer(this.buffer);
        this.expressionDeParser.setSelectVisitor(this.selectDeParser);
        this.expressionDeParser.setBuffer(this.buffer);
        this.selectDeParser.setExpressionVisitor(this.expressionDeParser);
        UpsertDeParser upsertDeParser = new UpsertDeParser(this.expressionDeParser, this.selectDeParser, this.buffer);
        upsertDeParser.deParse(upsert);
    }

    @Override
    public void visit(UseStatement use) {
        new UseStatementDeParser(this.buffer).deParse(use);
    }
}

