/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp.extensions;

import java.io.Serializable;
import org.apache.fop.fo.extensions.ExtensionAttachment;
import org.apache.fop.util.XMLizable;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class AFPPageSetup
implements ExtensionAttachment,
Serializable,
XMLizable {
    private static final long serialVersionUID = 7190606822558332901L;
    public static final String CATEGORY = "apache:fop:extensions:afp";
    private String elementName;
    private String name;
    private String value;
    private String content;
    private static final String ATT_NAME = "name";
    private static final String ATT_VALUE = "value";

    public AFPPageSetup(String elementName) {
        this.elementName = elementName;
    }

    public String getElementName() {
        return this.elementName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String source) {
        this.value = source;
    }

    public String getCategory() {
        return CATEGORY;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String toString() {
        return "AFPPageSetup(element-name=" + this.getElementName() + " name=" + this.getName() + ")";
    }

    public void toSAX(ContentHandler handler) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        if (this.name != null && this.name.length() > 0) {
            atts.addAttribute(null, ATT_NAME, ATT_NAME, "CDATA", this.name);
        }
        if (this.value != null && this.value.length() > 0) {
            atts.addAttribute(null, ATT_VALUE, ATT_VALUE, "CDATA", this.value);
        }
        handler.startElement(CATEGORY, this.elementName, this.elementName, atts);
        if (this.content != null && this.content.length() > 0) {
            char[] chars = this.content.toCharArray();
            handler.characters(chars, 0, chars.length);
        }
        handler.endElement(CATEGORY, this.elementName, this.elementName);
    }
}

