/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils.wrappers;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.dbutils.ProxyFactory;

public class SqlNullCheckedResultSet
implements InvocationHandler {
    private static final Map<String, Method> nullMethods = new HashMap<String, Method>();
    private static final String GET_NULL_PREFIX = "getNull";
    private static final ProxyFactory factory;
    private InputStream nullAsciiStream = null;
    private BigDecimal nullBigDecimal = null;
    private InputStream nullBinaryStream = null;
    private Blob nullBlob = null;
    private boolean nullBoolean = false;
    private byte nullByte = 0;
    private byte[] nullBytes = null;
    private Reader nullCharacterStream = null;
    private Clob nullClob = null;
    private Date nullDate = null;
    private double nullDouble = 0.0;
    private float nullFloat = 0.0f;
    private int nullInt = 0;
    private long nullLong = 0L;
    private Object nullObject = null;
    private Ref nullRef = null;
    private short nullShort = 0;
    private String nullString = null;
    private Time nullTime = null;
    private Timestamp nullTimestamp = null;
    private URL nullURL = null;
    private final ResultSet rs;

    public static ResultSet wrap(ResultSet resultSet) {
        return factory.createResultSet(new SqlNullCheckedResultSet(resultSet));
    }

    public SqlNullCheckedResultSet(ResultSet resultSet) {
        this.rs = resultSet;
    }

    public InputStream getNullAsciiStream() {
        return this.nullAsciiStream;
    }

    public BigDecimal getNullBigDecimal() {
        return this.nullBigDecimal;
    }

    public InputStream getNullBinaryStream() {
        return this.nullBinaryStream;
    }

    public Blob getNullBlob() {
        return this.nullBlob;
    }

    public boolean getNullBoolean() {
        return this.nullBoolean;
    }

    public byte getNullByte() {
        return this.nullByte;
    }

    public byte[] getNullBytes() {
        if (this.nullBytes == null) {
            return null;
        }
        byte[] byArray = new byte[this.nullBytes.length];
        System.arraycopy(this.nullBytes, 0, byArray, 0, this.nullBytes.length);
        return byArray;
    }

    public Reader getNullCharacterStream() {
        return this.nullCharacterStream;
    }

    public Clob getNullClob() {
        return this.nullClob;
    }

    public Date getNullDate() {
        if (this.nullDate != null) {
            return new Date(this.nullDate.getTime());
        }
        return null;
    }

    public double getNullDouble() {
        return this.nullDouble;
    }

    public float getNullFloat() {
        return this.nullFloat;
    }

    public int getNullInt() {
        return this.nullInt;
    }

    public long getNullLong() {
        return this.nullLong;
    }

    public Object getNullObject() {
        return this.nullObject;
    }

    public Ref getNullRef() {
        return this.nullRef;
    }

    public short getNullShort() {
        return this.nullShort;
    }

    public String getNullString() {
        return this.nullString;
    }

    public Time getNullTime() {
        return this.nullTime;
    }

    public Timestamp getNullTimestamp() {
        if (this.nullTimestamp != null) {
            return new Timestamp(this.nullTimestamp.getTime());
        }
        return null;
    }

    public URL getNullURL() {
        return this.nullURL;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        object = method.invoke((Object)this.rs, objectArray);
        if ((method = nullMethods.get(method.getName())) != null && this.rs.wasNull()) {
            return method.invoke((Object)this, null);
        }
        return object;
    }

    public void setNullAsciiStream(InputStream inputStream) {
        this.nullAsciiStream = inputStream;
    }

    public void setNullBigDecimal(BigDecimal bigDecimal) {
        this.nullBigDecimal = bigDecimal;
    }

    public void setNullBinaryStream(InputStream inputStream) {
        this.nullBinaryStream = inputStream;
    }

    public void setNullBlob(Blob blob) {
        this.nullBlob = blob;
    }

    public void setNullBoolean(boolean bl) {
        this.nullBoolean = bl;
    }

    public void setNullByte(byte by) {
        this.nullByte = by;
    }

    public void setNullBytes(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        this.nullBytes = byArray2;
    }

    public void setNullCharacterStream(Reader reader) {
        this.nullCharacterStream = reader;
    }

    public void setNullClob(Clob clob) {
        this.nullClob = clob;
    }

    public void setNullDate(Date date) {
        this.nullDate = date != null ? new Date(date.getTime()) : null;
    }

    public void setNullDouble(double d2) {
        this.nullDouble = d2;
    }

    public void setNullFloat(float f2) {
        this.nullFloat = f2;
    }

    public void setNullInt(int n) {
        this.nullInt = n;
    }

    public void setNullLong(long l) {
        this.nullLong = l;
    }

    public void setNullObject(Object object) {
        this.nullObject = object;
    }

    public void setNullRef(Ref ref) {
        this.nullRef = ref;
    }

    public void setNullShort(short s) {
        this.nullShort = s;
    }

    public void setNullString(String string) {
        this.nullString = string;
    }

    public void setNullTime(Time time) {
        this.nullTime = time;
    }

    public void setNullTimestamp(Timestamp timestamp) {
        this.nullTimestamp = timestamp != null ? new Timestamp(timestamp.getTime()) : null;
    }

    public void setNullURL(URL uRL) {
        this.nullURL = uRL;
    }

    static {
        Method[] methodArray = SqlNullCheckedResultSet.class.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            String string = methodArray[i].getName();
            if (!string.startsWith(GET_NULL_PREFIX)) continue;
            string = "get" + string.substring(7);
            nullMethods.put(string, methodArray[i]);
        }
        factory = ProxyFactory.instance();
    }
}

