/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils.handlers;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.dbutils.RowProcessor;
import org.apache.commons.dbutils.handlers.AbstractKeyedHandler;
import org.apache.commons.dbutils.handlers.ArrayHandler;

public class BeanMapHandler<K, V>
extends AbstractKeyedHandler<K, V> {
    private final Class<V> type;
    private final RowProcessor convert;
    private final int columnIndex;
    private final String columnName;

    public BeanMapHandler(Class<V> clazz) {
        this(clazz, ArrayHandler.ROW_PROCESSOR, 1, null);
    }

    public BeanMapHandler(Class<V> clazz, RowProcessor rowProcessor) {
        this(clazz, rowProcessor, 1, null);
    }

    public BeanMapHandler(Class<V> clazz, int n) {
        this(clazz, ArrayHandler.ROW_PROCESSOR, n, null);
    }

    public BeanMapHandler(Class<V> clazz, String string) {
        this(clazz, ArrayHandler.ROW_PROCESSOR, 1, string);
    }

    private BeanMapHandler(Class<V> clazz, RowProcessor rowProcessor, int n, String string) {
        this.type = clazz;
        this.convert = rowProcessor;
        this.columnIndex = n;
        this.columnName = string;
    }

    @Override
    protected K createKey(ResultSet resultSet) throws SQLException {
        if (this.columnName == null) {
            return (K)resultSet.getObject(this.columnIndex);
        }
        return (K)resultSet.getObject(this.columnName);
    }

    @Override
    protected V createRow(ResultSet resultSet) throws SQLException {
        return this.convert.toBean(resultSet, this.type);
    }
}

