/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import org.apache.commons.dbutils.BasicRowProcessor;
import org.apache.commons.dbutils.RowProcessor;

public class ResultSetIterator
implements Iterator<Object[]> {
    private final ResultSet rs;
    private final RowProcessor convert;

    public ResultSetIterator(ResultSet resultSet) {
        this(resultSet, new BasicRowProcessor());
    }

    public ResultSetIterator(ResultSet resultSet, RowProcessor rowProcessor) {
        this.rs = resultSet;
        this.convert = rowProcessor;
    }

    @Override
    public boolean hasNext() {
        try {
            return !this.rs.isLast();
        }
        catch (SQLException sQLException) {
            this.rethrow(sQLException);
            return false;
        }
    }

    @Override
    public Object[] next() {
        try {
            this.rs.next();
            return this.convert.toArray(this.rs);
        }
        catch (SQLException sQLException) {
            this.rethrow(sQLException);
            return null;
        }
    }

    @Override
    public void remove() {
        try {
            this.rs.deleteRow();
            return;
        }
        catch (SQLException sQLException) {
            this.rethrow(sQLException);
            return;
        }
    }

    protected void rethrow(SQLException sQLException) {
        throw new RuntimeException(sQLException.getMessage());
    }

    public static Iterable<Object[]> iterable(final ResultSet resultSet) {
        return new Iterable<Object[]>(){

            @Override
            public final Iterator<Object[]> iterator() {
                return new ResultSetIterator(resultSet);
            }
        };
    }
}

