/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.dbutils.AbstractQueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;

public class QueryRunner
extends AbstractQueryRunner {
    public QueryRunner() {
    }

    public QueryRunner(boolean bl) {
        super(bl);
    }

    public QueryRunner(DataSource dataSource) {
        super(dataSource);
    }

    public QueryRunner(DataSource dataSource, boolean bl) {
        super(dataSource, bl);
    }

    public int[] batch(Connection connection, String string, Object[][] objectArray) throws SQLException {
        return this.batch(connection, false, string, objectArray);
    }

    public int[] batch(String string, Object[][] objectArray) throws SQLException {
        Connection connection = this.prepareConnection();
        return this.batch(connection, true, string, objectArray);
    }

    private int[] batch(Connection connection, boolean bl, String string, Object[][] objectArray) throws SQLException {
        if (connection == null) {
            throw new SQLException("Null connection");
        }
        if (string == null) {
            if (bl) {
                this.close(connection);
            }
            throw new SQLException("Null SQL statement");
        }
        if (objectArray == null) {
            if (bl) {
                this.close(connection);
            }
            throw new SQLException("Null parameters. If parameters aren't need, pass an empty array.");
        }
        PreparedStatement preparedStatement = null;
        int[] nArray = null;
        try {
            preparedStatement = this.prepareStatement(connection, string);
            for (int i = 0; i < objectArray.length; ++i) {
                this.fillStatement(preparedStatement, objectArray[i]);
                preparedStatement.addBatch();
            }
            nArray = preparedStatement.executeBatch();
        }
        catch (SQLException sQLException) {
            this.rethrow(sQLException, string, (Object[])objectArray);
        }
        finally {
            this.close(preparedStatement);
            if (bl) {
                this.close(connection);
            }
        }
        return nArray;
    }

    @Deprecated
    public <T> T query(Connection connection, String string, Object object, ResultSetHandler<T> resultSetHandler) throws SQLException {
        return this.query(connection, false, string, resultSetHandler, object);
    }

    @Deprecated
    public <T> T query(Connection connection, String string, Object[] objectArray, ResultSetHandler<T> resultSetHandler) throws SQLException {
        return this.query(connection, false, string, resultSetHandler, objectArray);
    }

    public <T> T query(Connection connection, String string, ResultSetHandler<T> resultSetHandler, Object ... objectArray) throws SQLException {
        return this.query(connection, false, string, resultSetHandler, objectArray);
    }

    public <T> T query(Connection connection, String string, ResultSetHandler<T> resultSetHandler) throws SQLException {
        return this.query(connection, false, string, resultSetHandler, null);
    }

    @Deprecated
    public <T> T query(String string, Object object, ResultSetHandler<T> resultSetHandler) throws SQLException {
        Connection connection = this.prepareConnection();
        return this.query(connection, true, string, resultSetHandler, object);
    }

    @Deprecated
    public <T> T query(String string, Object[] objectArray, ResultSetHandler<T> resultSetHandler) throws SQLException {
        Connection connection = this.prepareConnection();
        return this.query(connection, true, string, resultSetHandler, objectArray);
    }

    public <T> T query(String string, ResultSetHandler<T> resultSetHandler, Object ... objectArray) throws SQLException {
        Connection connection = this.prepareConnection();
        return this.query(connection, true, string, resultSetHandler, objectArray);
    }

    public <T> T query(String string, ResultSetHandler<T> resultSetHandler) throws SQLException {
        Connection connection = this.prepareConnection();
        return this.query(connection, true, string, resultSetHandler, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T query(Connection connection, boolean bl, String string, ResultSetHandler<T> resultSetHandler, Object ... objectArray) throws SQLException {
        if (connection == null) {
            throw new SQLException("Null connection");
        }
        if (string == null) {
            if (!bl) throw new SQLException("Null SQL statement");
            this.close(connection);
            throw new SQLException("Null SQL statement");
        }
        if (resultSetHandler == null) {
            if (!bl) throw new SQLException("Null ResultSetHandler");
            this.close(connection);
            throw new SQLException("Null ResultSetHandler");
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        T t = null;
        try {
            preparedStatement = this.prepareStatement(connection, string);
            this.fillStatement(preparedStatement, objectArray);
            resultSet = this.wrap(preparedStatement.executeQuery());
            t = resultSetHandler.handle(resultSet);
            try {
                this.close(resultSet);
                return t;
            }
            finally {
                this.close(preparedStatement);
                if (bl) {
                    this.close(connection);
                }
            }
        }
        catch (SQLException sQLException) {
            this.rethrow(sQLException, string, objectArray);
            return t;
        }
        finally {
            try {
                this.close(resultSet);
            }
            finally {
                this.close(preparedStatement);
                if (bl) {
                    this.close(connection);
                }
            }
        }
    }

    public int update(Connection connection, String string) throws SQLException {
        return this.update(connection, false, string, null);
    }

    public int update(Connection connection, String string, Object object) throws SQLException {
        return this.update(connection, false, string, object);
    }

    public int update(Connection connection, String string, Object ... objectArray) throws SQLException {
        return this.update(connection, false, string, objectArray);
    }

    public int update(String string) throws SQLException {
        Connection connection = this.prepareConnection();
        return this.update(connection, true, string, null);
    }

    public int update(String string, Object object) throws SQLException {
        Connection connection = this.prepareConnection();
        return this.update(connection, true, string, object);
    }

    public int update(String string, Object ... objectArray) throws SQLException {
        Connection connection = this.prepareConnection();
        return this.update(connection, true, string, objectArray);
    }

    private int update(Connection connection, boolean bl, String string, Object ... objectArray) throws SQLException {
        if (connection == null) {
            throw new SQLException("Null connection");
        }
        if (string == null) {
            if (bl) {
                this.close(connection);
            }
            throw new SQLException("Null SQL statement");
        }
        PreparedStatement preparedStatement = null;
        int n = 0;
        try {
            preparedStatement = this.prepareStatement(connection, string);
            this.fillStatement(preparedStatement, objectArray);
            n = preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            this.rethrow(sQLException, string, objectArray);
        }
        finally {
            this.close(preparedStatement);
            if (bl) {
                this.close(connection);
            }
        }
        return n;
    }

    public <T> T insert(String string, ResultSetHandler<T> resultSetHandler) throws SQLException {
        QueryRunner queryRunner = this;
        return queryRunner.insert(queryRunner.prepareConnection(), true, string, resultSetHandler, null);
    }

    public <T> T insert(String string, ResultSetHandler<T> resultSetHandler, Object ... objectArray) throws SQLException {
        QueryRunner queryRunner = this;
        return queryRunner.insert(queryRunner.prepareConnection(), true, string, resultSetHandler, objectArray);
    }

    public <T> T insert(Connection connection, String string, ResultSetHandler<T> resultSetHandler) throws SQLException {
        return this.insert(connection, false, string, resultSetHandler, null);
    }

    public <T> T insert(Connection connection, String string, ResultSetHandler<T> resultSetHandler, Object ... objectArray) throws SQLException {
        return this.insert(connection, false, string, resultSetHandler, objectArray);
    }

    private <T> T insert(Connection connection, boolean bl, String string, ResultSetHandler<T> resultSetHandler, Object ... objectArray) throws SQLException {
        if (connection == null) {
            throw new SQLException("Null connection");
        }
        if (string == null) {
            if (bl) {
                this.close(connection);
            }
            throw new SQLException("Null SQL statement");
        }
        if (resultSetHandler == null) {
            if (bl) {
                this.close(connection);
            }
            throw new SQLException("Null ResultSetHandler");
        }
        PreparedStatement preparedStatement = null;
        T t = null;
        try {
            preparedStatement = connection.prepareStatement(string, 1);
            this.fillStatement(preparedStatement, objectArray);
            preparedStatement.executeUpdate();
            ResultSet resultSet = preparedStatement.getGeneratedKeys();
            t = resultSetHandler.handle(resultSet);
        }
        catch (SQLException sQLException) {
            this.rethrow(sQLException, string, objectArray);
        }
        finally {
            this.close(preparedStatement);
            if (bl) {
                this.close(connection);
            }
        }
        return t;
    }

    public <T> T insertBatch(String string, ResultSetHandler<T> resultSetHandler, Object[][] objectArray) throws SQLException {
        QueryRunner queryRunner = this;
        return queryRunner.insertBatch(queryRunner.prepareConnection(), true, string, resultSetHandler, objectArray);
    }

    public <T> T insertBatch(Connection connection, String string, ResultSetHandler<T> resultSetHandler, Object[][] objectArray) throws SQLException {
        return this.insertBatch(connection, false, string, resultSetHandler, objectArray);
    }

    private <T> T insertBatch(Connection connection, boolean bl, String string, ResultSetHandler<T> resultSetHandler, Object[][] objectArray) throws SQLException {
        if (connection == null) {
            throw new SQLException("Null connection");
        }
        if (string == null) {
            if (bl) {
                this.close(connection);
            }
            throw new SQLException("Null SQL statement");
        }
        if (objectArray == null) {
            if (bl) {
                this.close(connection);
            }
            throw new SQLException("Null parameters. If parameters aren't need, pass an empty array.");
        }
        PreparedStatement preparedStatement = null;
        T t = null;
        try {
            preparedStatement = this.prepareStatement(connection, string, 1);
            for (int i = 0; i < objectArray.length; ++i) {
                this.fillStatement(preparedStatement, objectArray[i]);
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
            ResultSet resultSet = preparedStatement.getGeneratedKeys();
            t = resultSetHandler.handle(resultSet);
        }
        catch (SQLException sQLException) {
            try {
                this.rethrow(sQLException, string, (Object[])objectArray);
            }
            catch (Throwable throwable) {
                this.close(preparedStatement);
                if (bl) {
                    this.close(connection);
                }
                throw throwable;
            }
            this.close(preparedStatement);
            if (bl) {
                this.close(connection);
            }
        }
        this.close(preparedStatement);
        if (bl) {
            this.close(connection);
        }
        return t;
    }
}

