/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;

public class QueryLoader {
    private static final QueryLoader instance = new QueryLoader();
    private static final Pattern dotXml = Pattern.compile(".+\\.[xX][mM][lL]");
    private final Map<String, Map<String, String>> queries = new HashMap<String, Map<String, String>>();

    public static QueryLoader instance() {
        return instance;
    }

    protected QueryLoader() {
    }

    public synchronized Map<String, String> load(String string) throws IOException {
        Map<String, String> map = this.queries.get(string);
        if (map == null) {
            map = this.loadQueries(string);
            this.queries.put(string, map);
        }
        return map;
    }

    protected Map<String, String> loadQueries(String object) throws IOException {
        InputStream inputStream = this.getClass().getResourceAsStream((String)object);
        if (inputStream == null) {
            throw new IllegalArgumentException((String)object + " not found.");
        }
        Properties properties = new Properties();
        try {
            if (dotXml.matcher((CharSequence)object).matches()) {
                properties.loadFromXML(inputStream);
            } else {
                properties.load(inputStream);
            }
        }
        finally {
            inputStream.close();
        }
        object = new HashMap<Object, Object>(properties);
        return object;
    }

    public synchronized void unload(String string) {
        this.queries.remove(string);
    }
}

