/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;

public class ProxyFactory {
    private static final ProxyFactory instance = new ProxyFactory();

    public static ProxyFactory instance() {
        return instance;
    }

    protected ProxyFactory() {
    }

    public <T> T newProxyInstance(Class<T> clazz, InvocationHandler invocationHandler) {
        return clazz.cast(Proxy.newProxyInstance(invocationHandler.getClass().getClassLoader(), new Class[]{clazz}, invocationHandler));
    }

    public CallableStatement createCallableStatement(InvocationHandler invocationHandler) {
        return this.newProxyInstance(CallableStatement.class, invocationHandler);
    }

    public Connection createConnection(InvocationHandler invocationHandler) {
        return this.newProxyInstance(Connection.class, invocationHandler);
    }

    public Driver createDriver(InvocationHandler invocationHandler) {
        return this.newProxyInstance(Driver.class, invocationHandler);
    }

    public PreparedStatement createPreparedStatement(InvocationHandler invocationHandler) {
        return this.newProxyInstance(PreparedStatement.class, invocationHandler);
    }

    public ResultSet createResultSet(InvocationHandler invocationHandler) {
        return this.newProxyInstance(ResultSet.class, invocationHandler);
    }

    public ResultSetMetaData createResultSetMetaData(InvocationHandler invocationHandler) {
        return this.newProxyInstance(ResultSetMetaData.class, invocationHandler);
    }

    public Statement createStatement(InvocationHandler invocationHandler) {
        return this.newProxyInstance(Statement.class, invocationHandler);
    }
}

