/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Logger;

public final class DbUtils {
    public static void close(Connection connection) throws SQLException {
        if (connection != null) {
            connection.close();
        }
    }

    public static void close(ResultSet resultSet) throws SQLException {
        if (resultSet != null) {
            resultSet.close();
        }
    }

    public static void close(Statement statement) throws SQLException {
        if (statement != null) {
            statement.close();
        }
    }

    public static void closeQuietly(Connection connection) {
        try {
            DbUtils.close(connection);
            return;
        }
        catch (SQLException sQLException) {
            return;
        }
    }

    public static void closeQuietly(Connection connection, Statement statement, ResultSet resultSet) {
        try {
            DbUtils.closeQuietly(resultSet);
        }
        finally {
            try {
                DbUtils.closeQuietly(statement);
            }
            finally {
                DbUtils.closeQuietly(connection);
            }
        }
    }

    public static void closeQuietly(ResultSet resultSet) {
        try {
            DbUtils.close(resultSet);
            return;
        }
        catch (SQLException sQLException) {
            return;
        }
    }

    public static void closeQuietly(Statement statement) {
        try {
            DbUtils.close(statement);
            return;
        }
        catch (SQLException sQLException) {
            return;
        }
    }

    public static void commitAndClose(Connection connection) throws SQLException {
        if (connection != null) {
            try {
                connection.commit();
                return;
            }
            finally {
                connection.close();
            }
        }
    }

    public static void commitAndCloseQuietly(Connection connection) {
        try {
            DbUtils.commitAndClose(connection);
            return;
        }
        catch (SQLException sQLException) {
            return;
        }
    }

    public static boolean loadDriver(String string) {
        return DbUtils.loadDriver(DbUtils.class.getClassLoader(), string);
    }

    public static boolean loadDriver(ClassLoader constructor, String string) {
        try {
            constructor = ((ClassLoader)((Object)constructor)).loadClass(string);
            if (!Driver.class.isAssignableFrom((Class<?>)((Object)constructor))) {
                return false;
            }
            boolean bl = (constructor = ((Class)((Object)constructor)).getConstructor(new Class[0])).isAccessible();
            if (!bl) {
                constructor.setAccessible(true);
            }
            try {
                Driver driver = (Driver)constructor.newInstance(new Object[0]);
                DriverManager.registerDriver(new DriverProxy(driver));
            }
            finally {
                constructor.setAccessible(bl);
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void printStackTrace(SQLException sQLException) {
        DbUtils.printStackTrace(sQLException, new PrintWriter(System.err));
    }

    public static void printStackTrace(SQLException sQLException, PrintWriter printWriter) {
        while (sQLException != null) {
            sQLException.printStackTrace(printWriter);
            if ((sQLException = sQLException.getNextException()) == null) continue;
            printWriter.println("Next SQLException:");
        }
    }

    public static void printWarnings(Connection connection) {
        DbUtils.printWarnings(connection, new PrintWriter(System.err));
    }

    public static void printWarnings(Connection object, PrintWriter printWriter) {
        if (object != null) {
            try {
                DbUtils.printStackTrace(object.getWarnings(), printWriter);
                return;
            }
            catch (SQLException sQLException) {
                object = sQLException;
                DbUtils.printStackTrace(sQLException, printWriter);
            }
        }
    }

    public static void rollback(Connection connection) throws SQLException {
        if (connection != null) {
            connection.rollback();
        }
    }

    public static void rollbackAndClose(Connection connection) throws SQLException {
        if (connection != null) {
            try {
                connection.rollback();
                return;
            }
            finally {
                connection.close();
            }
        }
    }

    public static void rollbackAndCloseQuietly(Connection connection) {
        try {
            DbUtils.rollbackAndClose(connection);
            return;
        }
        catch (SQLException sQLException) {
            return;
        }
    }

    private static final class DriverProxy
    implements Driver {
        private boolean parentLoggerSupported = true;
        private final Driver adapted;

        public DriverProxy(Driver driver) {
            this.adapted = driver;
        }

        @Override
        public final boolean acceptsURL(String string) throws SQLException {
            return this.adapted.acceptsURL(string);
        }

        @Override
        public final Connection connect(String string, Properties properties) throws SQLException {
            return this.adapted.connect(string, properties);
        }

        @Override
        public final int getMajorVersion() {
            return this.adapted.getMajorVersion();
        }

        @Override
        public final int getMinorVersion() {
            return this.adapted.getMinorVersion();
        }

        @Override
        public final DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
            return this.adapted.getPropertyInfo(string, properties);
        }

        @Override
        public final boolean jdbcCompliant() {
            return this.adapted.jdbcCompliant();
        }

        @Override
        public final Logger getParentLogger() throws SQLFeatureNotSupportedException {
            if (this.parentLoggerSupported) {
                try {
                    Method method = this.adapted.getClass().getMethod("getParentLogger", new Class[0]);
                    return (Logger)method.invoke((Object)this.adapted, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    this.parentLoggerSupported = false;
                    throw new SQLFeatureNotSupportedException(noSuchMethodException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    this.parentLoggerSupported = false;
                    throw new SQLFeatureNotSupportedException(illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    this.parentLoggerSupported = false;
                    throw new SQLFeatureNotSupportedException(invocationTargetException);
                }
            }
            throw new SQLFeatureNotSupportedException();
        }
    }
}

