/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.dbutils.BeanProcessor;
import org.apache.commons.dbutils.RowProcessor;

public class BasicRowProcessor
implements RowProcessor {
    private static final BeanProcessor defaultConvert = new BeanProcessor();
    private static final BasicRowProcessor instance = new BasicRowProcessor();
    private final BeanProcessor convert;

    @Deprecated
    public static BasicRowProcessor instance() {
        return instance;
    }

    public BasicRowProcessor() {
        this(defaultConvert);
    }

    public BasicRowProcessor(BeanProcessor beanProcessor) {
        this.convert = beanProcessor;
    }

    @Override
    public Object[] toArray(ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = resultSet.getObject(i + 1);
        }
        return objectArray;
    }

    @Override
    public <T> T toBean(ResultSet resultSet, Class<T> clazz) throws SQLException {
        return this.convert.toBean(resultSet, clazz);
    }

    @Override
    public <T> List<T> toBeanList(ResultSet resultSet, Class<T> clazz) throws SQLException {
        return this.convert.toBeanList(resultSet, clazz);
    }

    @Override
    public Map<String, Object> toMap(ResultSet resultSet) throws SQLException {
        CaseInsensitiveHashMap caseInsensitiveHashMap = new CaseInsensitiveHashMap();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        for (int i = 1; i <= n; ++i) {
            String string = resultSetMetaData.getColumnLabel(i);
            if (string == null || 0 == string.length()) {
                string = resultSetMetaData.getColumnName(i);
            }
            caseInsensitiveHashMap.put(string, resultSet.getObject(i));
        }
        return caseInsensitiveHashMap;
    }

    private static class CaseInsensitiveHashMap
    extends LinkedHashMap<String, Object> {
        private final Map<String, String> lowerCaseMap = new HashMap<String, String>();
        private static final long serialVersionUID = -2848100435296897392L;

        private CaseInsensitiveHashMap() {
        }

        @Override
        public boolean containsKey(Object object) {
            object = this.lowerCaseMap.get(object.toString().toLowerCase(Locale.ENGLISH));
            return super.containsKey(object);
        }

        @Override
        public Object get(Object object) {
            object = this.lowerCaseMap.get(object.toString().toLowerCase(Locale.ENGLISH));
            return super.get(object);
        }

        @Override
        public Object put(String string, Object object) {
            String string2 = this.lowerCaseMap.put(string.toLowerCase(Locale.ENGLISH), string);
            string2 = super.remove(string2);
            super.put(string, object);
            return string2;
        }

        @Override
        public void putAll(Map<? extends String, ?> object) {
            for (Map.Entry entry : object.entrySet()) {
                String string = (String)entry.getKey();
                Object entry2 = entry.getValue();
                this.put(string, entry2);
            }
        }

        @Override
        public Object remove(Object object) {
            object = this.lowerCaseMap.remove(object.toString().toLowerCase(Locale.ENGLISH));
            return super.remove(object);
        }
    }
}

