/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.apache.commons.dbutils.ResultSetHandler;

public abstract class BaseResultSetHandler<T>
implements ResultSetHandler<T> {
    private ResultSet rs;

    @Override
    public final T handle(ResultSet resultSet) throws SQLException {
        if (this.rs != null) {
            throw new IllegalStateException("Re-entry not allowed!");
        }
        this.rs = resultSet;
        try {
            resultSet = this.handle();
            return (T)resultSet;
        }
        finally {
            this.rs = null;
        }
    }

    protected abstract T handle() throws SQLException;

    protected final boolean absolute(int n) throws SQLException {
        return this.rs.absolute(n);
    }

    protected final void afterLast() throws SQLException {
        this.rs.afterLast();
    }

    protected final void beforeFirst() throws SQLException {
        this.rs.beforeFirst();
    }

    protected final void cancelRowUpdates() throws SQLException {
        this.rs.cancelRowUpdates();
    }

    protected final void clearWarnings() throws SQLException {
        this.rs.clearWarnings();
    }

    protected final void close() throws SQLException {
        this.rs.close();
    }

    protected final void deleteRow() throws SQLException {
        this.rs.deleteRow();
    }

    protected final int findColumn(String string) throws SQLException {
        return this.rs.findColumn(string);
    }

    protected final boolean first() throws SQLException {
        return this.rs.first();
    }

    protected final Array getArray(int n) throws SQLException {
        return this.rs.getArray(n);
    }

    protected final Array getArray(String string) throws SQLException {
        return this.rs.getArray(string);
    }

    protected final InputStream getAsciiStream(int n) throws SQLException {
        return this.rs.getAsciiStream(n);
    }

    protected final InputStream getAsciiStream(String string) throws SQLException {
        return this.rs.getAsciiStream(string);
    }

    @Deprecated
    protected final BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return this.rs.getBigDecimal(n, n2);
    }

    protected final BigDecimal getBigDecimal(int n) throws SQLException {
        return this.rs.getBigDecimal(n);
    }

    @Deprecated
    protected final BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.rs.getBigDecimal(string, n);
    }

    protected final BigDecimal getBigDecimal(String string) throws SQLException {
        return this.rs.getBigDecimal(string);
    }

    protected final InputStream getBinaryStream(int n) throws SQLException {
        return this.rs.getBinaryStream(n);
    }

    protected final InputStream getBinaryStream(String string) throws SQLException {
        return this.rs.getBinaryStream(string);
    }

    protected final Blob getBlob(int n) throws SQLException {
        return this.rs.getBlob(n);
    }

    protected final Blob getBlob(String string) throws SQLException {
        return this.rs.getBlob(string);
    }

    protected final boolean getBoolean(int n) throws SQLException {
        return this.rs.getBoolean(n);
    }

    protected final boolean getBoolean(String string) throws SQLException {
        return this.rs.getBoolean(string);
    }

    protected final byte getByte(int n) throws SQLException {
        return this.rs.getByte(n);
    }

    protected final byte getByte(String string) throws SQLException {
        return this.rs.getByte(string);
    }

    protected final byte[] getBytes(int n) throws SQLException {
        return this.rs.getBytes(n);
    }

    protected final byte[] getBytes(String string) throws SQLException {
        return this.rs.getBytes(string);
    }

    protected final Reader getCharacterStream(int n) throws SQLException {
        return this.rs.getCharacterStream(n);
    }

    protected final Reader getCharacterStream(String string) throws SQLException {
        return this.rs.getCharacterStream(string);
    }

    protected final Clob getClob(int n) throws SQLException {
        return this.rs.getClob(n);
    }

    protected final Clob getClob(String string) throws SQLException {
        return this.rs.getClob(string);
    }

    protected final int getConcurrency() throws SQLException {
        return this.rs.getConcurrency();
    }

    protected final String getCursorName() throws SQLException {
        return this.rs.getCursorName();
    }

    protected final Date getDate(int n, Calendar calendar) throws SQLException {
        return this.rs.getDate(n, calendar);
    }

    protected final Date getDate(int n) throws SQLException {
        return this.rs.getDate(n);
    }

    protected final Date getDate(String string, Calendar calendar) throws SQLException {
        return this.rs.getDate(string, calendar);
    }

    protected final Date getDate(String string) throws SQLException {
        return this.rs.getDate(string);
    }

    protected final double getDouble(int n) throws SQLException {
        return this.rs.getDouble(n);
    }

    protected final double getDouble(String string) throws SQLException {
        return this.rs.getDouble(string);
    }

    protected final int getFetchDirection() throws SQLException {
        return this.rs.getFetchDirection();
    }

    protected final int getFetchSize() throws SQLException {
        return this.rs.getFetchSize();
    }

    protected final float getFloat(int n) throws SQLException {
        return this.rs.getFloat(n);
    }

    protected final float getFloat(String string) throws SQLException {
        return this.rs.getFloat(string);
    }

    protected final int getHoldability() throws SQLException {
        return this.rs.getHoldability();
    }

    protected final int getInt(int n) throws SQLException {
        return this.rs.getInt(n);
    }

    protected final int getInt(String string) throws SQLException {
        return this.rs.getInt(string);
    }

    protected final long getLong(int n) throws SQLException {
        return this.rs.getLong(n);
    }

    protected final long getLong(String string) throws SQLException {
        return this.rs.getLong(string);
    }

    protected final ResultSetMetaData getMetaData() throws SQLException {
        return this.rs.getMetaData();
    }

    protected final Reader getNCharacterStream(int n) throws SQLException {
        return this.rs.getNCharacterStream(n);
    }

    protected final Reader getNCharacterStream(String string) throws SQLException {
        return this.rs.getNCharacterStream(string);
    }

    protected final NClob getNClob(int n) throws SQLException {
        return this.rs.getNClob(n);
    }

    protected final NClob getNClob(String string) throws SQLException {
        return this.rs.getNClob(string);
    }

    protected final String getNString(int n) throws SQLException {
        return this.rs.getNString(n);
    }

    protected final String getNString(String string) throws SQLException {
        return this.rs.getNString(string);
    }

    protected final Object getObject(int n, Map<String, Class<?>> map) throws SQLException {
        return this.rs.getObject(n, map);
    }

    protected final Object getObject(int n) throws SQLException {
        return this.rs.getObject(n);
    }

    protected final Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        return this.rs.getObject(string, map);
    }

    protected final Object getObject(String string) throws SQLException {
        return this.rs.getObject(string);
    }

    protected final Ref getRef(int n) throws SQLException {
        return this.rs.getRef(n);
    }

    protected final Ref getRef(String string) throws SQLException {
        return this.rs.getRef(string);
    }

    protected final int getRow() throws SQLException {
        return this.rs.getRow();
    }

    protected final RowId getRowId(int n) throws SQLException {
        return this.rs.getRowId(n);
    }

    protected final RowId getRowId(String string) throws SQLException {
        return this.rs.getRowId(string);
    }

    protected final SQLXML getSQLXML(int n) throws SQLException {
        return this.rs.getSQLXML(n);
    }

    protected final SQLXML getSQLXML(String string) throws SQLException {
        return this.rs.getSQLXML(string);
    }

    protected final short getShort(int n) throws SQLException {
        return this.rs.getShort(n);
    }

    protected final short getShort(String string) throws SQLException {
        return this.rs.getShort(string);
    }

    protected final Statement getStatement() throws SQLException {
        return this.rs.getStatement();
    }

    protected final String getString(int n) throws SQLException {
        return this.rs.getString(n);
    }

    protected final String getString(String string) throws SQLException {
        return this.rs.getString(string);
    }

    protected final Time getTime(int n, Calendar calendar) throws SQLException {
        return this.rs.getTime(n, calendar);
    }

    protected final Time getTime(int n) throws SQLException {
        return this.rs.getTime(n);
    }

    protected final Time getTime(String string, Calendar calendar) throws SQLException {
        return this.rs.getTime(string, calendar);
    }

    protected final Time getTime(String string) throws SQLException {
        return this.rs.getTime(string);
    }

    protected final Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.rs.getTimestamp(n, calendar);
    }

    protected final Timestamp getTimestamp(int n) throws SQLException {
        return this.rs.getTimestamp(n);
    }

    protected final Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.rs.getTimestamp(string, calendar);
    }

    protected final Timestamp getTimestamp(String string) throws SQLException {
        return this.rs.getTimestamp(string);
    }

    protected final int getType() throws SQLException {
        return this.rs.getType();
    }

    protected final URL getURL(int n) throws SQLException {
        return this.rs.getURL(n);
    }

    protected final URL getURL(String string) throws SQLException {
        return this.rs.getURL(string);
    }

    @Deprecated
    protected final InputStream getUnicodeStream(int n) throws SQLException {
        return this.rs.getUnicodeStream(n);
    }

    @Deprecated
    protected final InputStream getUnicodeStream(String string) throws SQLException {
        return this.rs.getUnicodeStream(string);
    }

    protected final SQLWarning getWarnings() throws SQLException {
        return this.rs.getWarnings();
    }

    protected final void insertRow() throws SQLException {
        this.rs.insertRow();
    }

    protected final boolean isAfterLast() throws SQLException {
        return this.rs.isAfterLast();
    }

    protected final boolean isBeforeFirst() throws SQLException {
        return this.rs.isBeforeFirst();
    }

    protected final boolean isClosed() throws SQLException {
        return this.rs.isClosed();
    }

    protected final boolean isFirst() throws SQLException {
        return this.rs.isFirst();
    }

    protected final boolean isLast() throws SQLException {
        return this.rs.isLast();
    }

    protected final boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return this.rs.isWrapperFor(clazz);
    }

    protected final boolean last() throws SQLException {
        return this.rs.last();
    }

    protected final void moveToCurrentRow() throws SQLException {
        this.rs.moveToCurrentRow();
    }

    protected final void moveToInsertRow() throws SQLException {
        this.rs.moveToInsertRow();
    }

    protected final boolean next() throws SQLException {
        return this.rs.next();
    }

    protected final boolean previous() throws SQLException {
        return this.rs.previous();
    }

    protected final void refreshRow() throws SQLException {
        this.rs.refreshRow();
    }

    protected final boolean relative(int n) throws SQLException {
        return this.rs.relative(n);
    }

    protected final boolean rowDeleted() throws SQLException {
        return this.rs.rowDeleted();
    }

    protected final boolean rowInserted() throws SQLException {
        return this.rs.rowInserted();
    }

    protected final boolean rowUpdated() throws SQLException {
        return this.rs.rowUpdated();
    }

    protected final void setFetchDirection(int n) throws SQLException {
        this.rs.setFetchDirection(n);
    }

    protected final void setFetchSize(int n) throws SQLException {
        this.rs.setFetchSize(n);
    }

    protected final <E> E unwrap(Class<E> clazz) throws SQLException {
        return this.rs.unwrap(clazz);
    }

    protected final void updateArray(int n, Array array) throws SQLException {
        this.rs.updateArray(n, array);
    }

    protected final void updateArray(String string, Array array) throws SQLException {
        this.rs.updateArray(string, array);
    }

    protected final void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.rs.updateAsciiStream(n, inputStream, n2);
    }

    protected final void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        this.rs.updateAsciiStream(n, inputStream, l);
    }

    protected final void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        this.rs.updateAsciiStream(n, inputStream);
    }

    protected final void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.rs.updateAsciiStream(string, inputStream, n);
    }

    protected final void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        this.rs.updateAsciiStream(string, inputStream, l);
    }

    protected final void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        this.rs.updateAsciiStream(string, inputStream);
    }

    protected final void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.rs.updateBigDecimal(n, bigDecimal);
    }

    protected final void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.rs.updateBigDecimal(string, bigDecimal);
    }

    protected final void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.rs.updateBinaryStream(n, inputStream, n2);
    }

    protected final void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        this.rs.updateBinaryStream(n, inputStream, l);
    }

    protected final void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        this.rs.updateBinaryStream(n, inputStream);
    }

    protected final void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.rs.updateBinaryStream(string, inputStream, n);
    }

    protected final void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        this.rs.updateBinaryStream(string, inputStream, l);
    }

    protected final void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        this.rs.updateBinaryStream(string, inputStream);
    }

    protected final void updateBlob(int n, Blob blob) throws SQLException {
        this.rs.updateBlob(n, blob);
    }

    protected final void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        this.rs.updateBlob(n, inputStream, l);
    }

    protected final void updateBlob(int n, InputStream inputStream) throws SQLException {
        this.rs.updateBlob(n, inputStream);
    }

    protected final void updateBlob(String string, Blob blob) throws SQLException {
        this.rs.updateBlob(string, blob);
    }

    protected final void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        this.rs.updateBlob(string, inputStream, l);
    }

    protected final void updateBlob(String string, InputStream inputStream) throws SQLException {
        this.rs.updateBlob(string, inputStream);
    }

    protected final void updateBoolean(int n, boolean bl) throws SQLException {
        this.rs.updateBoolean(n, bl);
    }

    protected final void updateBoolean(String string, boolean bl) throws SQLException {
        this.rs.updateBoolean(string, bl);
    }

    protected final void updateByte(int n, byte by) throws SQLException {
        this.rs.updateByte(n, by);
    }

    protected final void updateByte(String string, byte by) throws SQLException {
        this.rs.updateByte(string, by);
    }

    protected final void updateBytes(int n, byte[] byArray) throws SQLException {
        this.rs.updateBytes(n, byArray);
    }

    protected final void updateBytes(String string, byte[] byArray) throws SQLException {
        this.rs.updateBytes(string, byArray);
    }

    protected final void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.rs.updateCharacterStream(n, reader, n2);
    }

    protected final void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.rs.updateCharacterStream(n, reader, l);
    }

    protected final void updateCharacterStream(int n, Reader reader) throws SQLException {
        this.rs.updateCharacterStream(n, reader);
    }

    protected final void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.rs.updateCharacterStream(string, reader, n);
    }

    protected final void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.rs.updateCharacterStream(string, reader, l);
    }

    protected final void updateCharacterStream(String string, Reader reader) throws SQLException {
        this.rs.updateCharacterStream(string, reader);
    }

    protected final void updateClob(int n, Clob clob) throws SQLException {
        this.rs.updateClob(n, clob);
    }

    protected final void updateClob(int n, Reader reader, long l) throws SQLException {
        this.rs.updateClob(n, reader, l);
    }

    protected final void updateClob(int n, Reader reader) throws SQLException {
        this.rs.updateClob(n, reader);
    }

    protected final void updateClob(String string, Clob clob) throws SQLException {
        this.rs.updateClob(string, clob);
    }

    protected final void updateClob(String string, Reader reader, long l) throws SQLException {
        this.rs.updateClob(string, reader, l);
    }

    protected final void updateClob(String string, Reader reader) throws SQLException {
        this.rs.updateClob(string, reader);
    }

    protected final void updateDate(int n, Date date) throws SQLException {
        this.rs.updateDate(n, date);
    }

    protected final void updateDate(String string, Date date) throws SQLException {
        this.rs.updateDate(string, date);
    }

    protected final void updateDouble(int n, double d2) throws SQLException {
        this.rs.updateDouble(n, d2);
    }

    protected final void updateDouble(String string, double d2) throws SQLException {
        this.rs.updateDouble(string, d2);
    }

    protected final void updateFloat(int n, float f2) throws SQLException {
        this.rs.updateFloat(n, f2);
    }

    protected final void updateFloat(String string, float f2) throws SQLException {
        this.rs.updateFloat(string, f2);
    }

    protected final void updateInt(int n, int n2) throws SQLException {
        this.rs.updateInt(n, n2);
    }

    protected final void updateInt(String string, int n) throws SQLException {
        this.rs.updateInt(string, n);
    }

    protected final void updateLong(int n, long l) throws SQLException {
        this.rs.updateLong(n, l);
    }

    protected final void updateLong(String string, long l) throws SQLException {
        this.rs.updateLong(string, l);
    }

    protected final void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.rs.updateNCharacterStream(n, reader, l);
    }

    protected final void updateNCharacterStream(int n, Reader reader) throws SQLException {
        this.rs.updateNCharacterStream(n, reader);
    }

    protected final void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.rs.updateNCharacterStream(string, reader, l);
    }

    protected final void updateNCharacterStream(String string, Reader reader) throws SQLException {
        this.rs.updateNCharacterStream(string, reader);
    }

    protected final void updateNClob(int n, NClob nClob) throws SQLException {
        this.rs.updateNClob(n, nClob);
    }

    protected final void updateNClob(int n, Reader reader, long l) throws SQLException {
        this.rs.updateNClob(n, reader, l);
    }

    protected final void updateNClob(int n, Reader reader) throws SQLException {
        this.rs.updateNClob(n, reader);
    }

    protected final void updateNClob(String string, NClob nClob) throws SQLException {
        this.rs.updateNClob(string, nClob);
    }

    protected final void updateNClob(String string, Reader reader, long l) throws SQLException {
        this.rs.updateNClob(string, reader, l);
    }

    protected final void updateNClob(String string, Reader reader) throws SQLException {
        this.rs.updateNClob(string, reader);
    }

    protected final void updateNString(int n, String string) throws SQLException {
        this.rs.updateNString(n, string);
    }

    protected final void updateNString(String string, String string2) throws SQLException {
        this.rs.updateNString(string, string2);
    }

    protected final void updateNull(int n) throws SQLException {
        this.rs.updateNull(n);
    }

    protected final void updateNull(String string) throws SQLException {
        this.rs.updateNull(string);
    }

    protected final void updateObject(int n, Object object, int n2) throws SQLException {
        this.rs.updateObject(n, object, n2);
    }

    protected final void updateObject(int n, Object object) throws SQLException {
        this.rs.updateObject(n, object);
    }

    protected final void updateObject(String string, Object object, int n) throws SQLException {
        this.rs.updateObject(string, object, n);
    }

    protected final void updateObject(String string, Object object) throws SQLException {
        this.rs.updateObject(string, object);
    }

    protected final void updateRef(int n, Ref ref) throws SQLException {
        this.rs.updateRef(n, ref);
    }

    protected final void updateRef(String string, Ref ref) throws SQLException {
        this.rs.updateRef(string, ref);
    }

    protected final void updateRow() throws SQLException {
        this.rs.updateRow();
    }

    protected final void updateRowId(int n, RowId rowId) throws SQLException {
        this.rs.updateRowId(n, rowId);
    }

    protected final void updateRowId(String string, RowId rowId) throws SQLException {
        this.rs.updateRowId(string, rowId);
    }

    protected final void updateSQLXML(int n, SQLXML sQLXML) throws SQLException {
        this.rs.updateSQLXML(n, sQLXML);
    }

    protected final void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        this.rs.updateSQLXML(string, sQLXML);
    }

    protected final void updateShort(int n, short s) throws SQLException {
        this.rs.updateShort(n, s);
    }

    protected final void updateShort(String string, short s) throws SQLException {
        this.rs.updateShort(string, s);
    }

    protected final void updateString(int n, String string) throws SQLException {
        this.rs.updateString(n, string);
    }

    protected final void updateString(String string, String string2) throws SQLException {
        this.rs.updateString(string, string2);
    }

    protected final void updateTime(int n, Time time) throws SQLException {
        this.rs.updateTime(n, time);
    }

    protected final void updateTime(String string, Time time) throws SQLException {
        this.rs.updateTime(string, time);
    }

    protected final void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.rs.updateTimestamp(n, timestamp);
    }

    protected final void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.rs.updateTimestamp(string, timestamp);
    }

    protected final boolean wasNull() throws SQLException {
        return this.rs.wasNull();
    }

    protected final ResultSet getAdaptedResultSet() {
        return this.rs;
    }
}

