/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ResourceBundle;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.NoBodyOutputStream;

class NoBodyResponse
extends HttpServletResponseWrapper {
    private static final ResourceBundle lStrings = ResourceBundle.getBundle("javax.servlet.http.LocalStrings");
    private NoBodyOutputStream noBody = new NoBodyOutputStream();
    private PrintWriter writer;
    private boolean didSetContentLength;
    private boolean usingOutputStream;

    NoBodyResponse(HttpServletResponse httpServletResponse) {
        super(httpServletResponse);
    }

    void setContentLength() {
        if (!this.didSetContentLength) {
            if (this.writer != null) {
                this.writer.flush();
            }
            NoBodyResponse noBodyResponse = this;
            noBodyResponse.setContentLength(noBodyResponse.noBody.getContentLength());
        }
    }

    @Override
    public void setContentLength(int n) {
        super.setContentLength(n);
        this.didSetContentLength = true;
    }

    @Override
    public void setContentLengthLong(long l) {
        super.setContentLengthLong(l);
        this.didSetContentLength = true;
    }

    @Override
    public void setHeader(String string, String string2) {
        super.setHeader(string, string2);
        this.checkHeader(string);
    }

    @Override
    public void addHeader(String string, String string2) {
        super.addHeader(string, string2);
        this.checkHeader(string);
    }

    @Override
    public void setIntHeader(String string, int n) {
        super.setIntHeader(string, n);
        this.checkHeader(string);
    }

    @Override
    public void addIntHeader(String string, int n) {
        super.addIntHeader(string, n);
        this.checkHeader(string);
    }

    private void checkHeader(String string) {
        if ("content-length".equalsIgnoreCase(string)) {
            this.didSetContentLength = true;
        }
    }

    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        if (this.writer != null) {
            throw new IllegalStateException(lStrings.getString("err.ise.getOutputStream"));
        }
        this.usingOutputStream = true;
        return this.noBody;
    }

    @Override
    public PrintWriter getWriter() throws UnsupportedEncodingException {
        if (this.usingOutputStream) {
            throw new IllegalStateException(lStrings.getString("err.ise.getWriter"));
        }
        if (this.writer == null) {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)this.noBody, this.getCharacterEncoding());
            this.writer = new PrintWriter(outputStreamWriter);
        }
        return this.writer;
    }
}

