/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

import java.io.IOException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.NoBodyResponse;

public abstract class HttpServlet
extends GenericServlet {
    private static final String METHOD_DELETE = "DELETE";
    private static final String METHOD_HEAD = "HEAD";
    private static final String METHOD_GET = "GET";
    private static final String METHOD_OPTIONS = "OPTIONS";
    private static final String METHOD_POST = "POST";
    private static final String METHOD_PUT = "PUT";
    private static final String METHOD_TRACE = "TRACE";
    private static final String HEADER_IFMODSINCE = "If-Modified-Since";
    private static final String HEADER_LASTMOD = "Last-Modified";
    private static final String LSTRING_FILE = "javax.servlet.http.LocalStrings";
    private static ResourceBundle lStrings = ResourceBundle.getBundle("javax.servlet.http.LocalStrings");

    protected void doGet(HttpServletRequest object, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        object = object.getProtocol();
        String string = lStrings.getString("http.method_get_not_supported");
        if (((String)object).endsWith("1.1")) {
            httpServletResponse.sendError(405, string);
            return;
        }
        httpServletResponse.sendError(400, string);
    }

    protected long getLastModified(HttpServletRequest httpServletRequest) {
        return -1L;
    }

    protected void doHead(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse = new NoBodyResponse(httpServletResponse);
        this.doGet(httpServletRequest, httpServletResponse);
        ((NoBodyResponse)httpServletResponse).setContentLength();
    }

    protected void doPost(HttpServletRequest object, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        object = object.getProtocol();
        String string = lStrings.getString("http.method_post_not_supported");
        if (((String)object).endsWith("1.1")) {
            httpServletResponse.sendError(405, string);
            return;
        }
        httpServletResponse.sendError(400, string);
    }

    protected void doPut(HttpServletRequest object, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        object = object.getProtocol();
        String string = lStrings.getString("http.method_put_not_supported");
        if (((String)object).endsWith("1.1")) {
            httpServletResponse.sendError(405, string);
            return;
        }
        httpServletResponse.sendError(400, string);
    }

    protected void doDelete(HttpServletRequest object, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        object = object.getProtocol();
        String string = lStrings.getString("http.method_delete_not_supported");
        if (((String)object).endsWith("1.1")) {
            httpServletResponse.sendError(405, string);
            return;
        }
        httpServletResponse.sendError(400, string);
    }

    private Method[] getAllDeclaredMethods(Class<? extends HttpServlet> clazz) {
        Method[] methodArray = null;
        while (!clazz.equals(HttpServlet.class)) {
            Method[] methodArray2 = clazz.getDeclaredMethods();
            if (methodArray != null && methodArray.length > 0) {
                Method[] methodArray3 = methodArray;
                methodArray = new Method[methodArray2.length + methodArray3.length];
                System.arraycopy(methodArray2, 0, methodArray, 0, methodArray2.length);
                System.arraycopy(methodArray3, 0, methodArray, methodArray2.length, methodArray3.length);
            } else {
                methodArray = methodArray2;
            }
            clazz = clazz.getSuperclass();
        }
        if (methodArray != null) {
            return methodArray;
        }
        return new Method[0];
    }

    protected void doOptions(HttpServletRequest methodArray, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        HttpServlet httpServlet = this;
        methodArray = httpServlet.getAllDeclaredMethods(httpServlet.getClass());
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        for (int i = 0; i < methodArray.length; ++i) {
            String string = methodArray[i].getName();
            if (string.equals("doGet")) {
                bl = true;
                bl2 = true;
                continue;
            }
            if (string.equals("doPost")) {
                bl3 = true;
                continue;
            }
            if (string.equals("doPut")) {
                bl4 = true;
                continue;
            }
            if (!string.equals("doDelete")) continue;
            bl5 = true;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append(METHOD_GET);
        }
        if (bl2) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(METHOD_HEAD);
        }
        if (bl3) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(METHOD_POST);
        }
        if (bl4) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(METHOD_PUT);
        }
        if (bl5) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(METHOD_DELETE);
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append(", ");
        }
        stringBuilder.append(METHOD_TRACE);
        if (stringBuilder.length() > 0) {
            stringBuilder.append(", ");
        }
        stringBuilder.append(METHOD_OPTIONS);
        httpServletResponse.setHeader("Allow", stringBuilder.toString());
    }

    protected void doTrace(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        String string = "\r\n";
        StringBuilder stringBuilder = new StringBuilder("TRACE ").append(httpServletRequest.getRequestURI()).append(" ").append(httpServletRequest.getProtocol());
        Enumeration<String> enumeration = httpServletRequest.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            stringBuilder.append(string).append((String)object).append(": ").append(httpServletRequest.getHeader((String)object));
        }
        stringBuilder.append(string);
        int n = stringBuilder.length();
        httpServletResponse.setContentType("message/http");
        httpServletResponse.setContentLength(n);
        object = httpServletResponse.getOutputStream();
        ((ServletOutputStream)object).print(stringBuilder.toString());
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getMethod();
        if (string.equals(METHOD_GET)) {
            long l = this.getLastModified(httpServletRequest);
            if (l == -1L) {
                this.doGet(httpServletRequest, httpServletResponse);
                return;
            }
            long l2 = httpServletRequest.getDateHeader(HEADER_IFMODSINCE);
            if (l2 < l) {
                this.maybeSetLastModified(httpServletResponse, l);
                this.doGet(httpServletRequest, httpServletResponse);
                return;
            }
            httpServletResponse.setStatus(304);
            return;
        }
        if (string.equals(METHOD_HEAD)) {
            long l = this.getLastModified(httpServletRequest);
            this.maybeSetLastModified(httpServletResponse, l);
            this.doHead(httpServletRequest, httpServletResponse);
            return;
        }
        if (string.equals(METHOD_POST)) {
            this.doPost(httpServletRequest, httpServletResponse);
            return;
        }
        if (string.equals(METHOD_PUT)) {
            this.doPut(httpServletRequest, httpServletResponse);
            return;
        }
        if (string.equals(METHOD_DELETE)) {
            this.doDelete(httpServletRequest, httpServletResponse);
            return;
        }
        if (string.equals(METHOD_OPTIONS)) {
            this.doOptions(httpServletRequest, httpServletResponse);
            return;
        }
        if (string.equals(METHOD_TRACE)) {
            this.doTrace(httpServletRequest, httpServletResponse);
            return;
        }
        String string2 = lStrings.getString("http.method_not_implemented");
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string;
        string2 = MessageFormat.format(string2, objectArray2);
        httpServletResponse.sendError(501, string2);
    }

    private void maybeSetLastModified(HttpServletResponse httpServletResponse, long l) {
        if (httpServletResponse.containsHeader(HEADER_LASTMOD)) {
            return;
        }
        if (l >= 0L) {
            httpServletResponse.setDateHeader(HEADER_LASTMOD, l);
        }
    }

    @Override
    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        if (!(servletRequest instanceof HttpServletRequest) || !(servletResponse instanceof HttpServletResponse)) {
            throw new ServletException("non-HTTP request or response");
        }
        servletRequest = (HttpServletRequest)servletRequest;
        servletResponse = (HttpServletResponse)servletResponse;
        this.service((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse);
    }
}

