/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class Cookie
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -6454587001725327448L;
    private static final String TSPECIALS;
    private static final String LSTRING_FILE = "javax.servlet.http.LocalStrings";
    private static ResourceBundle lStrings;
    private String name;
    private String value;
    private String comment;
    private String domain;
    private int maxAge = -1;
    private String path;
    private boolean secure;
    private int version = 0;
    private boolean isHttpOnly = false;

    public Cookie(String string, String string2) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(lStrings.getString("err.cookie_name_blank"));
        }
        if (!this.isToken(string) || string.equalsIgnoreCase("Comment") || string.equalsIgnoreCase("Discard") || string.equalsIgnoreCase("Domain") || string.equalsIgnoreCase("Expires") || string.equalsIgnoreCase("Max-Age") || string.equalsIgnoreCase("Path") || string.equalsIgnoreCase("Secure") || string.equalsIgnoreCase("Version") || string.startsWith("$")) {
            string2 = lStrings.getString("err.cookie_name_is_token");
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = string;
            string2 = MessageFormat.format(string2, objectArray2);
            throw new IllegalArgumentException(string2);
        }
        this.name = string;
        this.value = string2;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public String getComment() {
        return this.comment;
    }

    public void setDomain(String string) {
        this.domain = string.toLowerCase(Locale.ENGLISH);
    }

    public String getDomain() {
        return this.domain;
    }

    public void setMaxAge(int n) {
        this.maxAge = n;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public String getPath() {
        return this.path;
    }

    public void setSecure(boolean bl) {
        this.secure = bl;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public String getName() {
        return this.name;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String getValue() {
        return this.value;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int n) {
        this.version = n;
    }

    private boolean isToken(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c2 >= ' ' && c2 < '\u007f' && TSPECIALS.indexOf(c2) == -1) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException.getMessage());
        }
    }

    public void setHttpOnly(boolean bl) {
        this.isHttpOnly = bl;
    }

    public boolean isHttpOnly() {
        return this.isHttpOnly;
    }

    static {
        lStrings = ResourceBundle.getBundle(LSTRING_FILE);
        TSPECIALS = Boolean.valueOf(System.getProperty("org.glassfish.web.rfc2109_cookie_names_enforced", "true")) != false ? "/()<>@,;:\\\"[]?={} \t" : ",; ";
    }
}

