/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.textstyling;

import fr.opensagres.xdocreport.core.document.SyntaxKind;
import fr.opensagres.xdocreport.core.registry.AbstractRegistry;
import fr.opensagres.xdocreport.document.discovery.ITextStylingTransformerDiscovery;
import fr.opensagres.xdocreport.document.textstyling.ITextStylingTransformer;
import java.util.HashMap;
import java.util.Map;

public class TextStylingTransformerRegistry
extends AbstractRegistry<ITextStylingTransformerDiscovery> {
    private static final TextStylingTransformerRegistry INSTANCE = new TextStylingTransformerRegistry();
    private final Map<String, ITextStylingTransformer> transformers = new HashMap<String, ITextStylingTransformer>();

    public TextStylingTransformerRegistry() {
        super(ITextStylingTransformerDiscovery.class);
    }

    public static TextStylingTransformerRegistry getRegistry() {
        return INSTANCE;
    }

    @Override
    protected boolean registerInstance(ITextStylingTransformerDiscovery discovery) {
        this.transformers.put(discovery.getId(), discovery.getTransformer());
        return true;
    }

    @Override
    protected void doDispose() {
        this.transformers.clear();
    }

    public ITextStylingTransformer getTextStylingTransformer(SyntaxKind syntaxKind) {
        return this.getTextStylingTransformer(syntaxKind.name());
    }

    public ITextStylingTransformer getTextStylingTransformer(String syntaxKind) {
        super.initializeIfNeeded();
        return this.transformers.get(syntaxKind);
    }
}

