/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.docx.preprocessor.sax.numbering;

import fr.opensagres.xdocreport.core.utils.StringUtils;
import fr.opensagres.xdocreport.document.docx.DocxUtils;
import fr.opensagres.xdocreport.document.docx.preprocessor.DefaultStyle;
import fr.opensagres.xdocreport.document.docx.template.DocxContextHelper;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedDocumentContentHandler;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedElement;
import fr.opensagres.xdocreport.template.formatter.IDocumentFormatter;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DocxNumberingDocumentContentHandler
extends BufferedDocumentContentHandler {
    private static final String DECIMAL = "decimal";
    private static final String BULLET = "bullet";
    private static final String W_ABSTRACT_NUM_ID_ATTR = "w:abstractNumId";
    private static final String W_VAL_ATTR = "w:val";
    private static final String W_NUM_ID_ATTR = "w:numId";
    private static final String ITEM_INFO = "___NumberInfo";
    private final IDocumentFormatter formatter;
    private final Map<String, Object> sharedContext;
    private String currentAbstractNumId;
    private Integer maxNumId;
    private boolean hasDynamicAbstractNum;

    public DocxNumberingDocumentContentHandler(IDocumentFormatter formatter, Map<String, Object> sharedContext) {
        this.formatter = formatter;
        this.sharedContext = sharedContext;
        this.hasDynamicAbstractNum = false;
    }

    @Override
    public boolean doStartElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (DocxUtils.isAbstractNum(uri, localName, name)) {
            this.currentAbstractNumId = attributes.getValue(W_ABSTRACT_NUM_ID_ATTR);
        } else if (DocxUtils.isNumFmt(uri, localName, name)) {
            String firstNumFmt = attributes.getValue(W_VAL_ATTR);
            if (StringUtils.isNotEmpty(firstNumFmt)) {
                DefaultStyle defaultStyle;
                if (BULLET.equals(firstNumFmt)) {
                    DefaultStyle defaultStyle2 = DocxContextHelper.getDefaultStyle(this.sharedContext);
                    if (defaultStyle2.getAbstractNumIdForUnordererList() == null) {
                        defaultStyle2.setAbstractNumIdForUnordererList(StringUtils.asInteger(this.currentAbstractNumId));
                    }
                } else if (DECIMAL.equals(firstNumFmt) && (defaultStyle = DocxContextHelper.getDefaultStyle(this.sharedContext)).getAbstractNumIdForOrdererList() == null) {
                    defaultStyle.setAbstractNumIdForOrdererList(StringUtils.asInteger(this.currentAbstractNumId));
                }
            }
        } else if (DocxUtils.isNum(uri, localName, name)) {
            DefaultStyle defaultStyle;
            Integer numId = StringUtils.asInteger(attributes.getValue(W_NUM_ID_ATTR));
            if (numId != null && ((defaultStyle = DocxContextHelper.getDefaultStyle(this.sharedContext)).getMaxNumId() == null || numId > defaultStyle.getMaxNumId())) {
                defaultStyle.setMaxNumId(numId);
            }
            this.generateDynamicAbstractNumIfNeeded();
        }
        return super.doStartElement(uri, localName, name, attributes);
    }

    private void generateDynamicAbstractNumIfNeeded() {
        if (this.hasDynamicAbstractNum) {
            return;
        }
        BufferedElement region = this.getCurrentElement();
        DefaultStyle defaultStyle = DocxContextHelper.getDefaultStyle(this.sharedContext);
        if (defaultStyle.getAbstractNumIdForUnordererList() == null) {
            region.append(this.formatter.getFunctionDirective("___NoEscapeStylesGenerator", "generateAbstractNumBullet", "___DefaultStyle"));
        }
        region.append(this.generateScriptsForDynamicOrderedNumbers());
        this.hasDynamicAbstractNum = true;
    }

    @Override
    public void doEndElement(String uri, String localName, String name) throws SAXException {
        if (DocxUtils.isAbstractNum(uri, localName, name)) {
            this.currentAbstractNumId = null;
        } else if (DocxUtils.isNumbering(uri, localName, name)) {
            this.generateDynamicAbstractNumIfNeeded();
            BufferedElement region = this.getCurrentElement();
            region.append(this.generateScriptsForDynamicNumbers());
        }
        super.doEndElement(uri, localName, name);
    }

    private String generateScriptsForDynamicNumbers() {
        StringBuilder script = new StringBuilder();
        String startIf = this.formatter.getStartIfDirective("___NumberingRegistry");
        script.append(startIf);
        String listInfos = this.formatter.formatAsSimpleField(false, "___NumberingRegistry", "numbers");
        String itemListInfos = this.formatter.formatAsSimpleField(false, ITEM_INFO);
        String startLoop = this.formatter.getStartLoopDirective(itemListInfos, listInfos);
        script.append(startLoop);
        String numId = this.formatter.formatAsSimpleField(true, ITEM_INFO, "numId");
        String abstractNumId = this.formatter.formatAsSimpleField(true, ITEM_INFO, "abstractNumId");
        script.append("<w:num w:numId=\"");
        script.append(numId);
        script.append("\">");
        script.append("<w:abstractNumId w:val=\"");
        script.append(abstractNumId);
        script.append("\"/>");
        script.append("</w:num>");
        script.append(this.formatter.getEndLoopDirective(itemListInfos));
        script.append(this.formatter.getEndIfDirective("___NumberingRegistry"));
        return script.toString();
    }

    private String generateScriptsForDynamicOrderedNumbers() {
        StringBuilder script = new StringBuilder();
        String startIf = this.formatter.getStartIfDirective("___NumberingRegistry");
        script.append(startIf);
        String listInfos = this.formatter.formatAsSimpleField(false, "___NumberingRegistry", "numbers");
        String itemListInfos = this.formatter.formatAsSimpleField(false, ITEM_INFO);
        String startLoop = this.formatter.getStartLoopDirective(itemListInfos, listInfos);
        script.append(startLoop);
        String abstractNumId = this.formatter.formatAsSimpleField(false, ITEM_INFO, "abstractNumId");
        String abstractNumOrdered = this.formatter.formatAsSimpleField(false, ITEM_INFO, "ordered");
        String startIfOrderedList = this.formatter.getStartIfDirective(abstractNumOrdered);
        script.append(startIfOrderedList);
        script.append(this.formatter.getFunctionDirective("___NoEscapeStylesGenerator", "generateAbstractNumDecimal", "___DefaultStyle", abstractNumId));
        script.append(this.formatter.getEndIfDirective(abstractNumOrdered));
        script.append(this.formatter.getEndLoopDirective(itemListInfos));
        script.append(this.formatter.getEndIfDirective("___NumberingRegistry"));
        return script.toString();
    }
}

