/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.odfdom.converter.internal.xhtml;

import fr.opensagres.odfdom.converter.core.ElementVisitorConverter;
import fr.opensagres.odfdom.converter.core.IURIResolver;
import fr.opensagres.odfdom.converter.core.utils.ODFUtils;
import fr.opensagres.odfdom.converter.core.utils.StringUtils;
import fr.opensagres.odfdom.converter.internal.xhtml.ODFXHTMLPage;
import fr.opensagres.odfdom.converter.xhtml.XHTMLOptions;
import fr.opensagres.xdocreport.core.utils.Base64Utility;
import fr.opensagres.xdocreport.xhtml.extension.StringEscapeUtils;
import fr.opensagres.xdocreport.xhtml.extension.XHTMLConstants;
import fr.opensagres.xdocreport.xhtml.extension.XHTMLPageContentBuffer;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.activation.MimetypesFileTypeMap;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawFrameElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawImageElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeMasterStylesElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeTextElement;
import org.odftoolkit.odfdom.dom.element.style.StyleFooterElement;
import org.odftoolkit.odfdom.dom.element.style.StyleHeaderElement;
import org.odftoolkit.odfdom.dom.element.style.StyleMasterPageElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableColumnPropertiesElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableColumnElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.odftoolkit.odfdom.dom.element.text.TextAElement;
import org.odftoolkit.odfdom.dom.element.text.TextHElement;
import org.odftoolkit.odfdom.dom.element.text.TextLineBreakElement;
import org.odftoolkit.odfdom.dom.element.text.TextListElement;
import org.odftoolkit.odfdom.dom.element.text.TextListItemElement;
import org.odftoolkit.odfdom.dom.element.text.TextListLevelStyleElementBase;
import org.odftoolkit.odfdom.dom.element.text.TextListLevelStyleNumberElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.dom.element.text.TextSpanElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.incubator.doc.text.OdfTextListStyle;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ElementVisitorForXHTML
extends ElementVisitorConverter
implements XHTMLConstants {
    private static final String _100 = "100%;";
    private static final String CHARACTER = "character";
    private static final String BLOCK = "block";
    private String masterPageLayoutName = null;
    private String currentMasterPageLayoutName = null;
    private final ODFXHTMLPage xhtml;
    private XHTMLPageContentBuffer currentXHTMLContent;
    private boolean exportImageAsBase64;
    private List<String> columnsWidth;
    private int cellIndex = -1;

    public ElementVisitorForXHTML(ODFXHTMLPage xhtml, XHTMLOptions options, OdfDocument odfDocument, OutputStream out, Writer writer) {
        super(odfDocument, options != null ? options.getExtractor() : null, out, writer);
        this.xhtml = xhtml;
        this.currentXHTMLContent = null;
        this.exportImageAsBase64 = options != null ? options.getExportImageAsBase64() : false;
    }

    @Override
    protected boolean isNeedImageStream() {
        return this.exportImageAsBase64;
    }

    public void visit(OfficeMasterStylesElement ele) {
        super.visit(ele);
    }

    public void visit(StyleMasterPageElement ele) {
        this.currentMasterPageLayoutName = ele.getStylePageLayoutNameAttribute();
        if (this.masterPageLayoutName == null) {
            this.masterPageLayoutName = this.currentMasterPageLayoutName;
            this.xhtml.getPageBeforeBody().setBodyClass(this.xhtml.getStyleEngine().getClassName(OdfStyleFamily.List.getName(), this.masterPageLayoutName));
        }
        super.visit(ele);
    }

    public void visit(StyleHeaderElement ele) {
        this.currentXHTMLContent = this.xhtml.getPageBodyContentHeader();
        this.visitMasterPageHeaderFooter((OdfElement)ele, this.xhtml.getStyleEngine().getMasterPageHeaderStyleName(this.currentMasterPageLayoutName));
    }

    public void visit(StyleFooterElement ele) {
        this.currentXHTMLContent = this.xhtml.getPageBodyContentFooter();
        this.visitMasterPageHeaderFooter((OdfElement)ele, this.xhtml.getStyleEngine().getMasterPageFooterStyleName(this.currentMasterPageLayoutName));
    }

    private void visitMasterPageHeaderFooter(OdfElement ele, String styleName) {
        String styleFamilyName = OdfStyleFamily.List.getName();
        this.visit("div", ele, styleName, styleFamilyName, new String[0]);
    }

    public void visit(OfficeTextElement ele) {
        this.currentXHTMLContent = this.xhtml.getPageBodyContentBody();
        this.visit("div", (OdfElement)ele, null, null, new String[0]);
    }

    public void visit(TextHElement ele) {
        int level = 1;
        Integer levelAsInteger = ele.getTextOutlineLevelAttribute();
        if (levelAsInteger != null && levelAsInteger <= 6) {
            level = levelAsInteger;
        }
        this.visit("h" + level, (OdfStylableElement)ele, new String[0]);
    }

    public void visit(TextPElement ele) {
        boolean addNbsp = ele.getFirstChild() == null;
        this.visit("p", (OdfStylableElement)ele, addNbsp, new String[0]);
    }

    public void visit(TextSpanElement ele) {
        boolean addNbsp = ele.getFirstChild() == null;
        this.visit("span", (OdfStylableElement)ele, addNbsp, new String[0]);
    }

    public void visit(TextAElement ele) {
        String href = ele.getXlinkHrefAttribute();
        ArrayList<String> attributes = new ArrayList<String>();
        attributes.add("href");
        attributes.add(href);
        this.visit("a", (OdfStylableElement)ele, attributes.toArray(StringUtils.EMPTY_STRING_ARRAY));
    }

    public void visit(TextListElement ele) {
        int level = 1;
        boolean numberedList = false;
        String styleName = ele.getTextStyleNameAttribute();
        if (StringUtils.isNotEmpty(styleName)) {
            try {
                OdfTextListStyle listStyle = this.odfDocument.getContentDom().getAutomaticStyles().getListStyle(styleName);
                if (listStyle != null) {
                    TextListLevelStyleElementBase levelListStyle = listStyle.getLevel(level);
                    numberedList = levelListStyle != null && TextListLevelStyleNumberElement.ELEMENT_NAME.equals((Object)levelListStyle.getOdfName());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        String elementName = numberedList ? "ol" : "ul";
        this.startVisit(elementName, (OdfElement)ele, new String[0]);
        this.endVisit(elementName, (OdfElement)ele);
    }

    public void visit(TextListItemElement ele) {
        this.visit("li", (OdfElement)ele, null, null, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(TableTableElement ele) {
        try {
            this.columnsWidth = ODFUtils.getColumnWidthsAsString((Node)ele, this.odfDocument);
            this.visit("table", (OdfStylableElement)ele, new String[0]);
        }
        finally {
            if (this.columnsWidth != null) {
                this.columnsWidth = null;
            }
        }
    }

    public void visit(TableTableColumnElement ele) {
        Integer numberColumnsRepeated;
        String[] attributes = null;
        OdfStyle style = ele.getAutomaticStyle();
        if (style != null) {
            Node node = null;
            NodeList nodes = style.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                if (!StyleTableColumnPropertiesElement.ELEMENT_NAME.getLocalName().equals(node.getLocalName())) continue;
                StyleTableColumnPropertiesElement columnPropertiesElement = (StyleTableColumnPropertiesElement)node;
                String width = columnPropertiesElement.getStyleRelColumnWidthAttribute();
                if (StringUtils.isEmpty(width)) {
                    width = columnPropertiesElement.getStyleColumnWidthAttribute();
                }
                if (!StringUtils.isNotEmpty(width)) break;
                attributes = new String[]{"width", ODFUtils.getDimensionAsPixel(width)};
                break;
            }
        }
        if ((numberColumnsRepeated = ele.getTableNumberColumnsRepeatedAttribute()) == null) {
            numberColumnsRepeated = 1;
        }
        for (int i = 0; i < numberColumnsRepeated; ++i) {
            this.startVisit("col", (OdfElement)ele, attributes);
            this.endVisit("col", (OdfElement)ele);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(TableTableRowElement ele) {
        try {
            this.cellIndex = -1;
            this.visit("tr", (OdfStylableElement)ele, new String[0]);
        }
        finally {
            if (this.cellIndex != -1) {
                this.cellIndex = -1;
            }
        }
    }

    public void visit(TableTableCellElement ele) {
        Integer rowSpan;
        ArrayList<String> attributes = new ArrayList<String>();
        Integer colSpan = ele.getTableNumberColumnsSpannedAttribute();
        if (colSpan != null && colSpan != 1) {
            attributes.add("colspan");
            attributes.add(String.valueOf(colSpan));
        }
        if ((rowSpan = ele.getTableNumberRowsSpannedAttribute()) != null && rowSpan != 1) {
            attributes.add("rowspan");
            attributes.add(String.valueOf(rowSpan));
        }
        this.visit("td", (OdfStylableElement)ele, attributes.toArray(StringUtils.EMPTY_STRING_ARRAY));
    }

    public void visit(DrawFrameElement ele) {
        Integer zIndex;
        String height;
        String width;
        String y;
        ArrayList<String> attributes = new ArrayList<String>();
        String name = ele.getDrawNameAttribute();
        if (!StringUtils.isEmpty(name)) {
            attributes.add("name");
            attributes.add(name);
        }
        StringBuilder htmlStyle = new StringBuilder();
        String x = ele.getSvgXAttribute();
        if (!StringUtils.isEmpty(x)) {
            htmlStyle.append("left:");
            htmlStyle.append(x);
            htmlStyle.append(';');
        }
        if (!StringUtils.isEmpty(y = ele.getSvgYAttribute())) {
            htmlStyle.append("top:");
            htmlStyle.append(y);
            htmlStyle.append(';');
        }
        if (!StringUtils.isEmpty(width = ele.getSvgWidthAttribute())) {
            htmlStyle.append("width:");
            htmlStyle.append(width);
            htmlStyle.append(';');
        }
        if (!StringUtils.isEmpty(height = ele.getSvgHeightAttribute())) {
            htmlStyle.append("height:");
            htmlStyle.append(height);
            htmlStyle.append(';');
        }
        if ((zIndex = ele.getDrawZIndexAttribute()) != null) {
            htmlStyle.append("z-index:");
            htmlStyle.append(String.valueOf(zIndex));
            htmlStyle.append(';');
        }
        if (htmlStyle.length() > 0) {
            attributes.add("style");
            attributes.add(htmlStyle.toString());
        }
        this.visit("div", (OdfStylableElement)ele, attributes.toArray(StringUtils.EMPTY_STRING_ARRAY));
    }

    @Override
    protected void visitImage(DrawImageElement ele, String href, byte[] imageStream) {
        ArrayList<String> attributes = new ArrayList<String>();
        if (this.exportImageAsBase64 && imageStream != null) {
            String mimeType = new MimetypesFileTypeMap().getContentType(new File(href));
            StringBuilder src = new StringBuilder();
            src.append("data:");
            src.append(mimeType + ";base64,");
            src.append(Base64Utility.encode(imageStream));
            attributes.add("src");
            attributes.add(src.toString());
        } else {
            String src = ele.getXlinkHrefAttribute();
            IURIResolver uriResolver = this.xhtml.getStyleEngine().getURIResolver();
            src = uriResolver.resolve(src);
            attributes.add("src");
            attributes.add(src);
        }
        Node parentNode = ele.getParentNode();
        if (parentNode instanceof DrawFrameElement) {
            DrawFrameElement frameElement = (DrawFrameElement)parentNode;
            attributes.add("style");
            StringBuilder styleAttr = new StringBuilder();
            styleAttr.append("width");
            styleAttr.append(':');
            styleAttr.append(_100);
            styleAttr.append("height");
            styleAttr.append(':');
            styleAttr.append(_100);
            String anchorType = frameElement.getTextAnchorTypeAttribute();
            if (!CHARACTER.equals(anchorType)) {
                styleAttr.append("display");
                styleAttr.append(':');
                styleAttr.append(BLOCK);
            }
            attributes.add(styleAttr.toString());
        }
        this.visit("img", (OdfElement)ele, null, null, attributes.toArray(StringUtils.EMPTY_STRING_ARRAY));
    }

    public void visit(TextLineBreakElement ele) {
        this.currentXHTMLContent.startEndElement("br");
    }

    private void visit(String elementName, OdfStylableElement ele, String ... attributes) {
        this.visit(elementName, ele, false, attributes);
    }

    private void visit(String elementName, OdfStylableElement ele, boolean addNbsp, String ... attributes) {
        String styleName = ele.getStyleName();
        String styleFamily = ele.getStyleFamily() != null ? ele.getStyleFamily().getName() : null;
        this.visit(elementName, (OdfElement)ele, addNbsp, styleName, styleFamily, attributes);
    }

    private void visit(String elementName, OdfElement ele, String styleName, String styleFamily, String ... attributes) {
        this.visit(elementName, ele, false, styleName, styleFamily, attributes);
    }

    private void visit(String elementName, OdfElement ele, boolean addNbsp, String styleName, String styleFamily, String ... attributes) {
        this.startVisit(elementName, ele, attributes);
        this.xhtml.getStyleEngine().applyStyles(styleFamily, styleName, this.currentXHTMLContent);
        this.endVisit(elementName, ele, addNbsp);
    }

    private void startVisit(String elementName, OdfElement element, String ... attributes) {
        this.currentXHTMLContent.startElementNotEnclosed(elementName);
        if (attributes != null) {
            String value = null;
            String name = null;
            for (int i = 0; i < attributes.length; ++i) {
                String attr = attributes[i];
                if (i % 2 == 0) {
                    name = attr;
                    continue;
                }
                value = attr;
                this.currentXHTMLContent.setAttribute(name, value);
                name = null;
                value = null;
            }
        }
    }

    private void endVisit(String elementName, OdfElement element) {
        this.endVisit(elementName, element, false);
    }

    private void endVisit(String elementName, OdfElement element, boolean addNbsp) {
        this.currentXHTMLContent.endElementNotEnclosed();
        super.visit(element);
        if (addNbsp) {
            this.currentXHTMLContent.setText("&nbsp;");
        }
        this.currentXHTMLContent.endElement(elementName);
    }

    @Override
    public void save() throws IOException {
        if (this.writer != null) {
            this.xhtml.save(this.writer);
        } else {
            this.xhtml.save(this.out);
        }
        super.save();
    }

    @Override
    protected void processTextNode(Text node) {
        String content = node.getTextContent();
        if (StringUtils.isNotEmpty(content)) {
            this.currentXHTMLContent.setText(StringEscapeUtils.escapeHtml(content));
        } else {
            this.currentXHTMLContent.setText("&nbsp;");
        }
    }
}

