/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils.handlers;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.commons.dbutils.RowProcessor;
import org.apache.commons.dbutils.handlers.AbstractKeyedHandler;
import org.apache.commons.dbutils.handlers.ArrayHandler;

public class KeyedHandler<K>
extends AbstractKeyedHandler<K, Map<String, Object>> {
    protected final RowProcessor convert;
    protected final int columnIndex;
    protected final String columnName;

    public KeyedHandler() {
        this(ArrayHandler.ROW_PROCESSOR, 1, null);
    }

    public KeyedHandler(RowProcessor rowProcessor) {
        this(rowProcessor, 1, null);
    }

    public KeyedHandler(int n) {
        this(ArrayHandler.ROW_PROCESSOR, n, null);
    }

    public KeyedHandler(String string) {
        this(ArrayHandler.ROW_PROCESSOR, 1, string);
    }

    private KeyedHandler(RowProcessor rowProcessor, int n, String string) {
        this.convert = rowProcessor;
        this.columnIndex = n;
        this.columnName = string;
    }

    @Override
    protected K createKey(ResultSet resultSet) throws SQLException {
        if (this.columnName == null) {
            return (K)resultSet.getObject(this.columnIndex);
        }
        return (K)resultSet.getObject(this.columnName);
    }

    @Override
    protected Map<String, Object> createRow(ResultSet resultSet) throws SQLException {
        return this.convert.toMap(resultSet);
    }
}

