/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils.handlers;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.RowProcessor;
import org.apache.commons.dbutils.handlers.ArrayHandler;

public class BeanListHandler<T>
implements ResultSetHandler<List<T>> {
    private final Class<T> type;
    private final RowProcessor convert;

    public BeanListHandler(Class<T> clazz) {
        this(clazz, ArrayHandler.ROW_PROCESSOR);
    }

    public BeanListHandler(Class<T> clazz, RowProcessor rowProcessor) {
        this.type = clazz;
        this.convert = rowProcessor;
    }

    @Override
    public List<T> handle(ResultSet resultSet) throws SQLException {
        return this.convert.toBeanList(resultSet, this.type);
    }
}

