/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BeanProcessor {
    protected static final int PROPERTY_NOT_FOUND = -1;
    private static final Map<Class<?>, Object> primitiveDefaults = new HashMap();
    private final Map<String, String> columnToPropertyOverrides;

    public BeanProcessor() {
        this(new HashMap<String, String>());
    }

    public BeanProcessor(Map<String, String> map) {
        if (map == null) {
            throw new IllegalArgumentException("columnToPropertyOverrides map cannot be null");
        }
        this.columnToPropertyOverrides = map;
    }

    public <T> T toBean(ResultSet resultSet, Class<T> clazz) throws SQLException {
        PropertyDescriptor[] propertyDescriptorArray = this.propertyDescriptors(clazz);
        Object object = resultSet.getMetaData();
        object = this.mapColumnsToProperties((ResultSetMetaData)object, propertyDescriptorArray);
        return this.createBean(resultSet, clazz, propertyDescriptorArray, (int[])object);
    }

    public <T> List<T> toBeanList(ResultSet resultSet, Class<T> clazz) throws SQLException {
        ArrayList<T> arrayList = new ArrayList<T>();
        if (!resultSet.next()) {
            return arrayList;
        }
        PropertyDescriptor[] propertyDescriptorArray = this.propertyDescriptors(clazz);
        Object object = resultSet.getMetaData();
        object = this.mapColumnsToProperties((ResultSetMetaData)object, propertyDescriptorArray);
        do {
            arrayList.add(this.createBean(resultSet, clazz, propertyDescriptorArray, (int[])object));
        } while (resultSet.next());
        return arrayList;
    }

    private <T> T createBean(ResultSet resultSet, Class<T> clazz, PropertyDescriptor[] propertyDescriptorArray, int[] nArray) throws SQLException {
        clazz = this.newInstance(clazz);
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] == -1) continue;
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[nArray[i]];
            Class<?> clazz2 = propertyDescriptor.getPropertyType();
            Object object = null;
            if (clazz2 != null && (object = this.processColumn(resultSet, i, clazz2)) == null && clazz2.isPrimitive()) {
                object = primitiveDefaults.get(clazz2);
            }
            this.callSetter(clazz, propertyDescriptor, object);
        }
        return (T)clazz;
    }

    private void callSetter(Object object, PropertyDescriptor propertyDescriptor, Object object2) throws SQLException {
        Method method = propertyDescriptor.getWriteMethod();
        if (method == null) {
            return;
        }
        Class<?>[] classArray = method.getParameterTypes();
        try {
            if (object2 instanceof java.util.Date) {
                String string = classArray[0].getName();
                if ("java.sql.Date".equals(string)) {
                    object2 = new Date(((java.util.Date)object2).getTime());
                } else if ("java.sql.Time".equals(string)) {
                    object2 = new Time(((java.util.Date)object2).getTime());
                } else if ("java.sql.Timestamp".equals(string)) {
                    object2 = (Timestamp)object2;
                    int n = ((Timestamp)object2).getNanos();
                    object2 = new Timestamp(((Timestamp)object2).getTime());
                    ((Timestamp)object2).setNanos(n);
                }
            } else if (object2 instanceof String && classArray[0].isEnum()) {
                object2 = Enum.valueOf(classArray[0].asSubclass(Enum.class), (String)object2);
            }
            if (!this.isCompatibleType(object2, classArray[0])) {
                throw new SQLException("Cannot set " + propertyDescriptor.getName() + ": incompatible types, cannot convert " + object2.getClass().getName() + " to " + classArray[0].getName());
            }
            method.invoke(object, object2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SQLException("Cannot set " + propertyDescriptor.getName() + ": " + illegalArgumentException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SQLException("Cannot set " + propertyDescriptor.getName() + ": " + illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new SQLException("Cannot set " + propertyDescriptor.getName() + ": " + invocationTargetException.getMessage());
        }
    }

    private boolean isCompatibleType(Object object, Class<?> clazz) {
        if (object == null || clazz.isInstance(object)) {
            return true;
        }
        if (clazz.equals(Integer.TYPE) && object instanceof Integer) {
            return true;
        }
        if (clazz.equals(Long.TYPE) && object instanceof Long) {
            return true;
        }
        if (clazz.equals(Double.TYPE) && object instanceof Double) {
            return true;
        }
        if (clazz.equals(Float.TYPE) && object instanceof Float) {
            return true;
        }
        if (clazz.equals(Short.TYPE) && object instanceof Short) {
            return true;
        }
        if (clazz.equals(Byte.TYPE) && object instanceof Byte) {
            return true;
        }
        if (clazz.equals(Character.TYPE) && object instanceof Character) {
            return true;
        }
        return clazz.equals(Boolean.TYPE) && object instanceof Boolean;
    }

    protected <T> T newInstance(Class<T> clazz) throws SQLException {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new SQLException("Cannot create " + clazz.getName() + ": " + instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SQLException("Cannot create " + clazz.getName() + ": " + illegalAccessException.getMessage());
        }
    }

    private PropertyDescriptor[] propertyDescriptors(Class<?> object) throws SQLException {
        try {
            object = Introspector.getBeanInfo(object);
        }
        catch (IntrospectionException introspectionException) {
            throw new SQLException("Bean introspection failed: " + introspectionException.getMessage());
        }
        return object.getPropertyDescriptors();
    }

    protected int[] mapColumnsToProperties(ResultSetMetaData resultSetMetaData, PropertyDescriptor[] propertyDescriptorArray) throws SQLException {
        int n = resultSetMetaData.getColumnCount();
        int[] nArray = new int[n + 1];
        Arrays.fill(nArray, -1);
        block0: for (int i = 1; i <= n; ++i) {
            String string;
            String string2 = resultSetMetaData.getColumnLabel(i);
            if (string2 == null || 0 == string2.length()) {
                string2 = resultSetMetaData.getColumnName(i);
            }
            if ((string = this.columnToPropertyOverrides.get(string2)) == null) {
                string = string2;
            }
            for (int j = 0; j < propertyDescriptorArray.length; ++j) {
                if (!string.equalsIgnoreCase(propertyDescriptorArray[j].getName())) continue;
                nArray[i] = j;
                continue block0;
            }
        }
        return nArray;
    }

    protected Object processColumn(ResultSet resultSet, int n, Class<?> clazz) throws SQLException {
        if (!clazz.isPrimitive() && resultSet.getObject(n) == null) {
            return null;
        }
        if (clazz.equals(String.class)) {
            return resultSet.getString(n);
        }
        if (clazz.equals(Integer.TYPE) || clazz.equals(Integer.class)) {
            return resultSet.getInt(n);
        }
        if (clazz.equals(Boolean.TYPE) || clazz.equals(Boolean.class)) {
            return resultSet.getBoolean(n);
        }
        if (clazz.equals(Long.TYPE) || clazz.equals(Long.class)) {
            return resultSet.getLong(n);
        }
        if (clazz.equals(Double.TYPE) || clazz.equals(Double.class)) {
            return resultSet.getDouble(n);
        }
        if (clazz.equals(Float.TYPE) || clazz.equals(Float.class)) {
            return Float.valueOf(resultSet.getFloat(n));
        }
        if (clazz.equals(Short.TYPE) || clazz.equals(Short.class)) {
            return resultSet.getShort(n);
        }
        if (clazz.equals(Byte.TYPE) || clazz.equals(Byte.class)) {
            return resultSet.getByte(n);
        }
        if (clazz.equals(Timestamp.class)) {
            return resultSet.getTimestamp(n);
        }
        if (clazz.equals(SQLXML.class)) {
            return resultSet.getSQLXML(n);
        }
        return resultSet.getObject(n);
    }

    static {
        primitiveDefaults.put(Integer.TYPE, 0);
        primitiveDefaults.put(Short.TYPE, (short)0);
        primitiveDefaults.put(Byte.TYPE, (byte)0);
        primitiveDefaults.put(Float.TYPE, Float.valueOf(0.0f));
        primitiveDefaults.put(Double.TYPE, 0.0);
        primitiveDefaults.put(Long.TYPE, 0L);
        primitiveDefaults.put(Boolean.TYPE, Boolean.FALSE);
        primitiveDefaults.put(Character.TYPE, Character.valueOf('\u0000'));
    }
}

