/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.sql.DataSource;
import org.apache.commons.dbutils.AbstractQueryRunner;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;

public class AsyncQueryRunner
extends AbstractQueryRunner {
    private final ExecutorService executorService;
    private final QueryRunner queryRunner;

    public AsyncQueryRunner(ExecutorService executorService, QueryRunner queryRunner) {
        this.executorService = executorService;
        this.queryRunner = queryRunner;
    }

    public AsyncQueryRunner(ExecutorService executorService) {
        this(null, false, executorService);
    }

    @Deprecated
    public AsyncQueryRunner(boolean bl, ExecutorService executorService) {
        this(null, bl, executorService);
    }

    @Deprecated
    public AsyncQueryRunner(DataSource dataSource, ExecutorService executorService) {
        this(dataSource, false, executorService);
    }

    @Deprecated
    public AsyncQueryRunner(DataSource dataSource, boolean bl, ExecutorService executorService) {
        super(dataSource, bl);
        this.executorService = executorService;
        this.queryRunner = new QueryRunner(dataSource, bl);
    }

    public Future<int[]> batch(final Connection connection, final String string, final Object[][] objectArray) throws SQLException {
        return this.executorService.submit(new Callable<int[]>(){

            @Override
            public int[] call() throws Exception {
                return AsyncQueryRunner.this.queryRunner.batch(connection, string, objectArray);
            }
        });
    }

    public Future<int[]> batch(final String string, final Object[][] objectArray) throws SQLException {
        return this.executorService.submit(new Callable<int[]>(){

            @Override
            public int[] call() throws Exception {
                return AsyncQueryRunner.this.queryRunner.batch(string, objectArray);
            }
        });
    }

    public <T> Future<T> query(final Connection connection, final String string, final ResultSetHandler<T> resultSetHandler, final Object ... objectArray) throws SQLException {
        return this.executorService.submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return AsyncQueryRunner.this.queryRunner.query(connection, string, resultSetHandler, objectArray);
            }
        });
    }

    public <T> Future<T> query(final Connection connection, final String string, final ResultSetHandler<T> resultSetHandler) throws SQLException {
        return this.executorService.submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return AsyncQueryRunner.this.queryRunner.query(connection, string, resultSetHandler);
            }
        });
    }

    public <T> Future<T> query(final String string, final ResultSetHandler<T> resultSetHandler, final Object ... objectArray) throws SQLException {
        return this.executorService.submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return AsyncQueryRunner.this.queryRunner.query(string, resultSetHandler, objectArray);
            }
        });
    }

    public <T> Future<T> query(final String string, final ResultSetHandler<T> resultSetHandler) throws SQLException {
        return this.executorService.submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return AsyncQueryRunner.this.queryRunner.query(string, resultSetHandler);
            }
        });
    }

    public Future<Integer> update(final Connection connection, final String string) throws SQLException {
        return this.executorService.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return AsyncQueryRunner.this.queryRunner.update(connection, string);
            }
        });
    }

    public Future<Integer> update(final Connection connection, final String string, final Object object) throws SQLException {
        return this.executorService.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return AsyncQueryRunner.this.queryRunner.update(connection, string, object);
            }
        });
    }

    public Future<Integer> update(final Connection connection, final String string, final Object ... objectArray) throws SQLException {
        return this.executorService.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return AsyncQueryRunner.this.queryRunner.update(connection, string, objectArray);
            }
        });
    }

    public Future<Integer> update(final String string) throws SQLException {
        return this.executorService.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return AsyncQueryRunner.this.queryRunner.update(string);
            }
        });
    }

    public Future<Integer> update(final String string, final Object object) throws SQLException {
        return this.executorService.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return AsyncQueryRunner.this.queryRunner.update(string, object);
            }
        });
    }

    public Future<Integer> update(final String string, final Object ... objectArray) throws SQLException {
        return this.executorService.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return AsyncQueryRunner.this.queryRunner.update(string, objectArray);
            }
        });
    }

    public <T> Future<T> insert(final String string, final ResultSetHandler<T> resultSetHandler) throws SQLException {
        return this.executorService.submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return AsyncQueryRunner.this.queryRunner.insert(string, resultSetHandler);
            }
        });
    }

    public <T> Future<T> insert(final String string, final ResultSetHandler<T> resultSetHandler, final Object ... objectArray) throws SQLException {
        return this.executorService.submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return AsyncQueryRunner.this.queryRunner.insert(string, resultSetHandler, objectArray);
            }
        });
    }

    public <T> Future<T> insert(final Connection connection, final String string, final ResultSetHandler<T> resultSetHandler) throws SQLException {
        return this.executorService.submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return AsyncQueryRunner.this.queryRunner.insert(connection, string, resultSetHandler);
            }
        });
    }

    public <T> Future<T> insert(final Connection connection, final String string, final ResultSetHandler<T> resultSetHandler, final Object ... objectArray) throws SQLException {
        return this.executorService.submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return AsyncQueryRunner.this.queryRunner.insert(connection, string, resultSetHandler, objectArray);
            }
        });
    }

    public <T> Future<T> insertBatch(final String string, final ResultSetHandler<T> resultSetHandler, final Object[][] objectArray) throws SQLException {
        return this.executorService.submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return AsyncQueryRunner.this.queryRunner.insertBatch(string, resultSetHandler, objectArray);
            }
        });
    }

    public <T> Future<T> insertBatch(final Connection connection, final String string, final ResultSetHandler<T> resultSetHandler, final Object[][] objectArray) throws SQLException {
        return this.executorService.submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return AsyncQueryRunner.this.queryRunner.insertBatch(connection, string, resultSetHandler, objectArray);
            }
        });
    }

    @Deprecated
    protected class UpdateCallableStatement
    implements Callable<Integer> {
        private final String sql;
        private final Object[] params;
        private final Connection conn;
        private final boolean closeConn;
        private final PreparedStatement ps;

        public UpdateCallableStatement(Connection connection, boolean bl, PreparedStatement preparedStatement, String string, Object ... objectArray) {
            this.sql = string;
            this.params = objectArray;
            this.conn = connection;
            this.closeConn = bl;
            this.ps = preparedStatement;
        }

        @Override
        public Integer call() throws SQLException {
            int n = 0;
            try {
                n = this.ps.executeUpdate();
            }
            catch (SQLException sQLException) {
                AsyncQueryRunner.this.rethrow(sQLException, this.sql, this.params);
            }
            finally {
                AsyncQueryRunner.this.close(this.ps);
                if (this.closeConn) {
                    AsyncQueryRunner.this.close(this.conn);
                }
            }
            return n;
        }
    }

    protected class QueryCallableStatement<T>
    implements Callable<T> {
        private final String sql;
        private final Object[] params;
        private final Connection conn;
        private final boolean closeConn;
        private final PreparedStatement ps;
        private final ResultSetHandler<T> rsh;

        public QueryCallableStatement(Connection connection, boolean bl, PreparedStatement preparedStatement, ResultSetHandler<T> resultSetHandler, String string, Object ... objectArray) {
            this.sql = string;
            this.params = objectArray;
            this.conn = connection;
            this.closeConn = bl;
            this.ps = preparedStatement;
            this.rsh = resultSetHandler;
        }

        @Override
        public T call() throws SQLException {
            ResultSet resultSet = null;
            T t = null;
            try {
                resultSet = AsyncQueryRunner.this.wrap(this.ps.executeQuery());
                t = this.rsh.handle(resultSet);
            }
            catch (SQLException sQLException) {
                AsyncQueryRunner.this.rethrow(sQLException, this.sql, this.params);
            }
            finally {
                try {
                    AsyncQueryRunner.this.close(resultSet);
                }
                finally {
                    AsyncQueryRunner.this.close(this.ps);
                    if (this.closeConn) {
                        AsyncQueryRunner.this.close(this.conn);
                    }
                }
            }
            return t;
        }
    }

    @Deprecated
    protected class BatchCallableStatement
    implements Callable<int[]> {
        private final String sql;
        private final Object[][] params;
        private final Connection conn;
        private final boolean closeConn;
        private final PreparedStatement ps;

        public BatchCallableStatement(String string, Object[][] objectArray, Connection connection, boolean bl, PreparedStatement preparedStatement) {
            this.sql = string;
            this.params = (Object[][])objectArray.clone();
            this.conn = connection;
            this.closeConn = bl;
            this.ps = preparedStatement;
        }

        @Override
        public int[] call() throws SQLException {
            int[] nArray = null;
            try {
                nArray = this.ps.executeBatch();
            }
            catch (SQLException sQLException) {
                AsyncQueryRunner.this.rethrow(sQLException, this.sql, (Object[])this.params);
            }
            finally {
                AsyncQueryRunner.this.close(this.ps);
                if (this.closeConn) {
                    AsyncQueryRunner.this.close(this.conn);
                }
            }
            return nArray;
        }
    }
}

