/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import javax.sql.DataSource;
import org.apache.commons.dbutils.DbUtils;

public abstract class AbstractQueryRunner {
    private volatile boolean pmdKnownBroken = false;
    @Deprecated
    protected final DataSource ds;

    public AbstractQueryRunner() {
        this.ds = null;
    }

    public AbstractQueryRunner(boolean bl) {
        this.pmdKnownBroken = bl;
        this.ds = null;
    }

    public AbstractQueryRunner(DataSource dataSource) {
        this.ds = dataSource;
    }

    public AbstractQueryRunner(DataSource dataSource, boolean bl) {
        this.pmdKnownBroken = bl;
        this.ds = dataSource;
    }

    public DataSource getDataSource() {
        return this.ds;
    }

    public boolean isPmdKnownBroken() {
        return this.pmdKnownBroken;
    }

    protected PreparedStatement prepareStatement(Connection connection, String string) throws SQLException {
        return connection.prepareStatement(string);
    }

    protected PreparedStatement prepareStatement(Connection connection, String string, int n) throws SQLException {
        return connection.prepareStatement(string, n);
    }

    protected Connection prepareConnection() throws SQLException {
        if (this.getDataSource() == null) {
            throw new SQLException("QueryRunner requires a DataSource to be invoked in this way, or a Connection should be passed in");
        }
        return this.getDataSource().getConnection();
    }

    public void fillStatement(PreparedStatement preparedStatement, Object ... objectArray) throws SQLException {
        int n;
        int n2;
        ParameterMetaData parameterMetaData = null;
        if (!this.pmdKnownBroken) {
            parameterMetaData = preparedStatement.getParameterMetaData();
            n2 = parameterMetaData.getParameterCount();
            int n3 = n = objectArray == null ? 0 : objectArray.length;
            if (n2 != n) {
                throw new SQLException("Wrong number of parameters: expected " + n2 + ", was given " + n);
            }
        }
        if (objectArray == null) {
            return;
        }
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            if (objectArray[n2] != null) {
                preparedStatement.setObject(n2 + 1, objectArray[n2]);
                continue;
            }
            n = 12;
            if (!this.pmdKnownBroken) {
                try {
                    n = parameterMetaData.getParameterType(n2 + 1);
                }
                catch (SQLException sQLException) {
                    this.pmdKnownBroken = true;
                }
            }
            preparedStatement.setNull(n2 + 1, n);
        }
    }

    public void fillStatementWithBean(PreparedStatement preparedStatement, Object object, PropertyDescriptor[] propertyDescriptorArray) throws SQLException {
        Object[] objectArray = new Object[propertyDescriptorArray.length];
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            Object object2 = propertyDescriptorArray[i];
            Method method = ((PropertyDescriptor)object2).getReadMethod();
            if (method == null) {
                throw new RuntimeException("No read method for bean property " + object.getClass() + " " + ((FeatureDescriptor)object2).getName());
            }
            try {
                object2 = method.invoke(object, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException("Couldn't invoke method: " + method, invocationTargetException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException("Couldn't invoke method with 0 arguments: " + method, illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException("Couldn't invoke method: " + method, illegalAccessException);
            }
            objectArray[i] = object2;
        }
        this.fillStatement(preparedStatement, objectArray);
    }

    public void fillStatementWithBean(PreparedStatement preparedStatement, Object object, String ... stringArray) throws SQLException {
        PropertyDescriptor[] propertyDescriptorArray;
        try {
            propertyDescriptorArray = Introspector.getBeanInfo(object.getClass()).getPropertyDescriptors();
        }
        catch (IntrospectionException introspectionException) {
            throw new RuntimeException("Couldn't introspect bean " + object.getClass().toString(), introspectionException);
        }
        PropertyDescriptor[] propertyDescriptorArray2 = new PropertyDescriptor[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string == null) {
                throw new NullPointerException("propertyName can't be null: " + i);
            }
            boolean bl = false;
            for (int j = 0; j < propertyDescriptorArray.length; ++j) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[j];
                if (!string.equals(propertyDescriptor.getName())) continue;
                propertyDescriptorArray2[i] = propertyDescriptor;
                bl = true;
                break;
            }
            if (bl) continue;
            throw new RuntimeException("Couldn't find bean property: " + object.getClass() + " " + string);
        }
        this.fillStatementWithBean(preparedStatement, object, propertyDescriptorArray2);
    }

    protected void rethrow(SQLException sQLException, String object, Object ... objectArray) throws SQLException {
        CharSequence charSequence = sQLException.getMessage();
        if (charSequence == null) {
            charSequence = "";
        }
        charSequence = new StringBuffer((String)charSequence);
        ((StringBuffer)charSequence).append(" Query: ");
        ((StringBuffer)charSequence).append((String)object);
        ((StringBuffer)charSequence).append(" Parameters: ");
        if (objectArray == null) {
            ((StringBuffer)charSequence).append("[]");
        } else {
            ((StringBuffer)charSequence).append(Arrays.deepToString(objectArray));
        }
        object = new SQLException(((StringBuffer)charSequence).toString(), sQLException.getSQLState(), sQLException.getErrorCode());
        ((SQLException)object).setNextException(sQLException);
        throw object;
    }

    protected ResultSet wrap(ResultSet resultSet) {
        return resultSet;
    }

    protected void close(Connection connection) throws SQLException {
        DbUtils.close(connection);
    }

    protected void close(Statement statement) throws SQLException {
        DbUtils.close(statement);
    }

    protected void close(ResultSet resultSet) throws SQLException {
        DbUtils.close(resultSet);
    }
}

