/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.servlet.HttpConstraintElement;
import javax.servlet.HttpMethodConstraintElement;
import javax.servlet.annotation.HttpMethodConstraint;
import javax.servlet.annotation.ServletSecurity;

public class ServletSecurityElement
extends HttpConstraintElement {
    private Collection<String> methodNames;
    private Collection<HttpMethodConstraintElement> methodConstraints;

    public ServletSecurityElement() {
        this.methodConstraints = new HashSet<HttpMethodConstraintElement>();
        this.methodNames = Collections.emptySet();
    }

    public ServletSecurityElement(HttpConstraintElement httpConstraintElement) {
        super(httpConstraintElement.getEmptyRoleSemantic(), httpConstraintElement.getTransportGuarantee(), httpConstraintElement.getRolesAllowed());
        this.methodConstraints = new HashSet<HttpMethodConstraintElement>();
        this.methodNames = Collections.emptySet();
    }

    public ServletSecurityElement(Collection<HttpMethodConstraintElement> hashSet) {
        this.methodConstraints = hashSet == null ? new HashSet() : hashSet;
        this.methodNames = this.checkMethodNames(this.methodConstraints);
    }

    public ServletSecurityElement(HttpConstraintElement httpConstraintElement, Collection<HttpMethodConstraintElement> hashSet) {
        super(httpConstraintElement.getEmptyRoleSemantic(), httpConstraintElement.getTransportGuarantee(), httpConstraintElement.getRolesAllowed());
        this.methodConstraints = hashSet == null ? new HashSet() : hashSet;
        this.methodNames = this.checkMethodNames(this.methodConstraints);
    }

    public ServletSecurityElement(ServletSecurity httpMethodConstraintArray) {
        super(httpMethodConstraintArray.value().value(), httpMethodConstraintArray.value().transportGuarantee(), httpMethodConstraintArray.value().rolesAllowed());
        this.methodConstraints = new HashSet<HttpMethodConstraintElement>();
        for (HttpMethodConstraint httpMethodConstraint : httpMethodConstraintArray.httpMethodConstraints()) {
            this.methodConstraints.add(new HttpMethodConstraintElement(httpMethodConstraint.value(), new HttpConstraintElement(httpMethodConstraint.emptyRoleSemantic(), httpMethodConstraint.transportGuarantee(), httpMethodConstraint.rolesAllowed())));
        }
        this.methodNames = this.checkMethodNames(this.methodConstraints);
    }

    public Collection<HttpMethodConstraintElement> getHttpMethodConstraints() {
        return Collections.unmodifiableCollection(this.methodConstraints);
    }

    public Collection<String> getMethodNames() {
        return Collections.unmodifiableCollection(this.methodNames);
    }

    private Collection<String> checkMethodNames(Collection<HttpMethodConstraintElement> object) {
        HashSet<String> hashSet = new HashSet<String>();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (HttpMethodConstraintElement)object.next();
            if (hashSet.add((String)(object2 = ((HttpMethodConstraintElement)object2).getMethodName()))) continue;
            throw new IllegalArgumentException("Duplicate HTTP method name: " + (String)object2);
        }
        return hashSet;
    }
}

