/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet;

import javax.servlet.annotation.ServletSecurity;

public class HttpConstraintElement {
    private ServletSecurity.EmptyRoleSemantic emptyRoleSemantic;
    private ServletSecurity.TransportGuarantee transportGuarantee;
    private String[] rolesAllowed;

    public HttpConstraintElement() {
        this(ServletSecurity.EmptyRoleSemantic.PERMIT);
    }

    public HttpConstraintElement(ServletSecurity.EmptyRoleSemantic emptyRoleSemantic) {
        this(emptyRoleSemantic, ServletSecurity.TransportGuarantee.NONE, new String[0]);
    }

    public HttpConstraintElement(ServletSecurity.TransportGuarantee transportGuarantee, String ... stringArray) {
        this(ServletSecurity.EmptyRoleSemantic.PERMIT, transportGuarantee, stringArray);
    }

    public HttpConstraintElement(ServletSecurity.EmptyRoleSemantic emptyRoleSemantic, ServletSecurity.TransportGuarantee transportGuarantee, String ... stringArray) {
        if (emptyRoleSemantic == ServletSecurity.EmptyRoleSemantic.DENY && stringArray.length > 0) {
            throw new IllegalArgumentException("Deny semantic with rolesAllowed");
        }
        this.emptyRoleSemantic = emptyRoleSemantic;
        this.transportGuarantee = transportGuarantee;
        this.rolesAllowed = this.copyStrings(stringArray);
    }

    public ServletSecurity.EmptyRoleSemantic getEmptyRoleSemantic() {
        return this.emptyRoleSemantic;
    }

    public ServletSecurity.TransportGuarantee getTransportGuarantee() {
        return this.transportGuarantee;
    }

    public String[] getRolesAllowed() {
        HttpConstraintElement httpConstraintElement = this;
        return httpConstraintElement.copyStrings(httpConstraintElement.rolesAllowed);
    }

    private String[] copyStrings(String[] stringArray) {
        String[] stringArray2 = null;
        if (stringArray != null) {
            int n = stringArray.length;
            stringArray2 = new String[n];
            if (n > 0) {
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
            }
        }
        if (stringArray2 != null) {
            return stringArray2;
        }
        return new String[0];
    }
}

