/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.task;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.task.Task;
import org.activiti.rest.service.api.engine.RestIdentityLink;
import org.activiti.rest.service.api.runtime.task.TaskBaseResource;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TaskIdentityLinkCollectionResource
extends TaskBaseResource {
    @RequestMapping(value={"/runtime/tasks/{taskId}/identitylinks"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<RestIdentityLink> getIdentityLinks(@PathVariable(value="taskId") String taskId, HttpServletRequest request) {
        Task task = this.getTaskFromRequest(taskId);
        return this.restResponseFactory.createRestIdentityLinks(this.taskService.getIdentityLinksForTask(task.getId()));
    }

    @RequestMapping(value={"/runtime/tasks/{taskId}/identitylinks"}, method={RequestMethod.POST}, produces={"application/json"})
    public RestIdentityLink createIdentityLink(@PathVariable(value="taskId") String taskId, @RequestBody RestIdentityLink identityLink, HttpServletRequest request, HttpServletResponse response) {
        Task task = this.getTaskFromRequest(taskId);
        if (identityLink.getGroup() == null && identityLink.getUser() == null) {
            throw new ActivitiIllegalArgumentException("A group or a user is required to create an identity link.");
        }
        if (identityLink.getGroup() != null && identityLink.getUser() != null) {
            throw new ActivitiIllegalArgumentException("Only one of user or group can be used to create an identity link.");
        }
        if (identityLink.getType() == null) {
            throw new ActivitiIllegalArgumentException("The identity link type is required.");
        }
        if (identityLink.getGroup() != null) {
            this.taskService.addGroupIdentityLink(task.getId(), identityLink.getGroup(), identityLink.getType());
        } else {
            this.taskService.addUserIdentityLink(task.getId(), identityLink.getUser(), identityLink.getType());
        }
        response.setStatus(HttpStatus.CREATED.value());
        return this.restResponseFactory.createRestIdentityLink(identityLink.getType(), identityLink.getUser(), identityLink.getGroup(), task.getId(), null, null);
    }
}

