/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.task;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.task.Attachment;
import org.activiti.engine.task.Task;
import org.activiti.rest.service.api.engine.AttachmentRequest;
import org.activiti.rest.service.api.engine.AttachmentResponse;
import org.activiti.rest.service.api.runtime.task.TaskBaseResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
public class TaskAttachmentCollectionResource
extends TaskBaseResource {
    @Autowired
    protected ObjectMapper objectMapper;

    @RequestMapping(value={"/runtime/tasks/{taskId}/attachments"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<AttachmentResponse> getAttachments(@PathVariable String taskId, HttpServletRequest request) {
        ArrayList<AttachmentResponse> result = new ArrayList<AttachmentResponse>();
        HistoricTaskInstance task = this.getHistoricTaskFromRequest(taskId);
        for (Attachment attachment : this.taskService.getTaskAttachments(task.getId())) {
            result.add(this.restResponseFactory.createAttachmentResponse(attachment));
        }
        return result;
    }

    @RequestMapping(value={"/runtime/tasks/{taskId}/attachments"}, method={RequestMethod.POST}, produces={"application/json"})
    public AttachmentResponse createAttachment(@PathVariable String taskId, HttpServletRequest request, HttpServletResponse response) {
        AttachmentResponse result = null;
        Task task = this.getTaskFromRequest(taskId);
        if (request instanceof MultipartHttpServletRequest) {
            result = this.createBinaryAttachment((MultipartHttpServletRequest)request, task, response);
        } else {
            AttachmentRequest attachmentRequest = null;
            try {
                attachmentRequest = (AttachmentRequest)this.objectMapper.readValue((InputStream)request.getInputStream(), AttachmentRequest.class);
            }
            catch (Exception e) {
                throw new ActivitiIllegalArgumentException("Failed to serialize to a AttachmentRequest instance", (Throwable)e);
            }
            if (attachmentRequest == null) {
                throw new ActivitiIllegalArgumentException("AttachmentRequest properties not found in request");
            }
            result = this.createSimpleAttachment(attachmentRequest, task);
        }
        response.setStatus(HttpStatus.CREATED.value());
        return result;
    }

    protected AttachmentResponse createSimpleAttachment(AttachmentRequest attachmentRequest, Task task) {
        if (attachmentRequest.getName() == null) {
            throw new ActivitiIllegalArgumentException("Attachment name is required.");
        }
        Attachment createdAttachment = this.taskService.createAttachment(attachmentRequest.getType(), task.getId(), task.getProcessInstanceId(), attachmentRequest.getName(), attachmentRequest.getDescription(), attachmentRequest.getExternalUrl());
        return this.restResponseFactory.createAttachmentResponse(createdAttachment);
    }

    protected AttachmentResponse createBinaryAttachment(MultipartHttpServletRequest request, Task task, HttpServletResponse response) {
        String name = null;
        String description = null;
        String type = null;
        Map paramMap = request.getParameterMap();
        for (String parameterName : paramMap.keySet()) {
            if (((String[])paramMap.get(parameterName)).length <= 0) continue;
            if (parameterName.equalsIgnoreCase("name")) {
                name = ((String[])paramMap.get(parameterName))[0];
                continue;
            }
            if (parameterName.equalsIgnoreCase("description")) {
                description = ((String[])paramMap.get(parameterName))[0];
                continue;
            }
            if (!parameterName.equalsIgnoreCase("type")) continue;
            type = ((String[])paramMap.get(parameterName))[0];
        }
        if (name == null) {
            throw new ActivitiIllegalArgumentException("Attachment name is required.");
        }
        if (request.getFileMap().size() == 0) {
            throw new ActivitiIllegalArgumentException("Attachment content is required.");
        }
        MultipartFile file = (MultipartFile)request.getFileMap().values().iterator().next();
        if (file == null) {
            throw new ActivitiIllegalArgumentException("Attachment content is required.");
        }
        try {
            Attachment createdAttachment = this.taskService.createAttachment(type, task.getId(), task.getProcessInstanceId(), name, description, file.getInputStream());
            response.setStatus(HttpStatus.CREATED.value());
            return this.restResponseFactory.createAttachmentResponse(createdAttachment);
        }
        catch (Exception e) {
            throw new ActivitiException("Error creating attachment response", (Throwable)e);
        }
    }
}

