/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.process;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntity;
import org.activiti.engine.runtime.Execution;
import org.activiti.rest.service.api.engine.variable.RestVariable;
import org.activiti.rest.service.api.runtime.process.BaseExecutionVariableResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
public class ProcessInstanceVariableResource
extends BaseExecutionVariableResource {
    @Autowired
    protected ObjectMapper objectMapper;

    @RequestMapping(value={"/runtime/process-instances/{processInstanceId}/variables/{variableName}"}, method={RequestMethod.GET}, produces={"application/json"})
    public RestVariable getVariable(@PathVariable(value="processInstanceId") String processInstanceId, @PathVariable(value="variableName") String variableName, @RequestParam(value="scope", required=false) String scope, HttpServletRequest request) {
        Execution execution = this.getProcessInstanceFromRequest(processInstanceId);
        return this.getVariableFromRequest(execution, variableName, scope, false);
    }

    @RequestMapping(value={"/runtime/process-instances/{processInstanceId}/variables/{variableName}"}, method={RequestMethod.PUT}, produces={"application/json"})
    public RestVariable updateVariable(@PathVariable(value="processInstanceId") String processInstanceId, @PathVariable(value="variableName") String variableName, HttpServletRequest request) {
        Execution execution = this.getProcessInstanceFromRequest(processInstanceId);
        RestVariable result = null;
        if (request instanceof MultipartHttpServletRequest) {
            result = this.setBinaryVariable((MultipartHttpServletRequest)request, execution, 3, false);
            if (!result.getName().equals(variableName)) {
                throw new ActivitiIllegalArgumentException("Variable name in the body should be equal to the name used in the requested URL.");
            }
        } else {
            RestVariable restVariable = null;
            try {
                restVariable = (RestVariable)this.objectMapper.readValue((InputStream)request.getInputStream(), RestVariable.class);
            }
            catch (Exception e) {
                throw new ActivitiIllegalArgumentException("request body could not be transformed to a RestVariable instance.");
            }
            if (restVariable == null) {
                throw new ActivitiException("Invalid body was supplied");
            }
            if (!restVariable.getName().equals(variableName)) {
                throw new ActivitiIllegalArgumentException("Variable name in the body should be equal to the name used in the requested URL.");
            }
            result = this.setSimpleVariable(restVariable, execution, false);
        }
        return result;
    }

    @RequestMapping(value={"/runtime/process-instances/{processInstanceId}/variables/{variableName}"}, method={RequestMethod.DELETE})
    public void deleteVariable(@PathVariable(value="processInstanceId") String processInstanceId, @PathVariable(value="variableName") String variableName, @RequestParam(value="scope", required=false) String scope, HttpServletResponse response) {
        Execution execution = this.getProcessInstanceFromRequest(processInstanceId);
        RestVariable.RestVariableScope variableScope = RestVariable.RestVariableScope.LOCAL;
        if (scope != null) {
            variableScope = RestVariable.getScopeFromString(scope);
        }
        if (!this.hasVariableOnScope(execution, variableName, variableScope)) {
            throw new ActivitiObjectNotFoundException("Execution '" + execution.getId() + "' doesn't have a variable '" + variableName + "' in scope " + variableScope.name().toLowerCase(), VariableInstanceEntity.class);
        }
        if (variableScope == RestVariable.RestVariableScope.LOCAL) {
            this.runtimeService.removeVariableLocal(execution.getId(), variableName);
        } else {
            this.runtimeService.removeVariable(execution.getParentId(), variableName);
        }
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    @Override
    protected RestVariable constructRestVariable(String variableName, Object value, RestVariable.RestVariableScope variableScope, String executionId, boolean includeBinary) {
        return this.restResponseFactory.createRestVariable(variableName, value, null, executionId, 3, includeBinary);
    }
}

