/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.repository;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.rest.service.api.engine.RestIdentityLink;
import org.activiti.rest.service.api.repository.BaseProcessDefinitionResource;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ProcessDefinitionIdentityLinkCollectionResource
extends BaseProcessDefinitionResource {
    @RequestMapping(value={"/repository/process-definitions/{processDefinitionId}/identitylinks"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<RestIdentityLink> getIdentityLinks(@PathVariable String processDefinitionId, HttpServletRequest request) {
        ProcessDefinition processDefinition = this.getProcessDefinitionFromRequest(processDefinitionId);
        return this.restResponseFactory.createRestIdentityLinks(this.repositoryService.getIdentityLinksForProcessDefinition(processDefinition.getId()));
    }

    @RequestMapping(value={"/repository/process-definitions/{processDefinitionId}/identitylinks"}, method={RequestMethod.POST}, produces={"application/json"})
    public RestIdentityLink createIdentityLink(@PathVariable String processDefinitionId, @RequestBody RestIdentityLink identityLink, HttpServletRequest request, HttpServletResponse response) {
        ProcessDefinition processDefinition = this.getProcessDefinitionFromRequest(processDefinitionId);
        if (identityLink.getGroup() == null && identityLink.getUser() == null) {
            throw new ActivitiIllegalArgumentException("A group or a user is required to create an identity link.");
        }
        if (identityLink.getGroup() != null && identityLink.getUser() != null) {
            throw new ActivitiIllegalArgumentException("Only one of user or group can be used to create an identity link.");
        }
        if (identityLink.getGroup() != null) {
            this.repositoryService.addCandidateStarterGroup(processDefinition.getId(), identityLink.getGroup());
        } else {
            this.repositoryService.addCandidateStarterUser(processDefinition.getId(), identityLink.getUser());
        }
        identityLink.setType("candidate");
        response.setStatus(HttpStatus.CREATED.value());
        return this.restResponseFactory.createRestIdentityLink(identityLink.getType(), identityLink.getUser(), identityLink.getGroup(), null, processDefinition.getId(), null);
    }
}

