/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.utils;

import com.bstek.ureport.Utils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Stack;

public class ElCompute {
    private Stack<Object> dataStack = new Stack();
    private Stack<Character> operateStack = new Stack();

    public static void main(String[] args) {
        long start = System.currentTimeMillis();
        String expr = "22/2*2-(5+(1*2))-2*2";
        for (int i = 0; i < 1; ++i) {
            ElCompute el = new ElCompute();
            Object data = el.doCompute(expr);
            System.out.println(data);
        }
        long end = System.currentTimeMillis();
        System.out.println(end - start);
    }

    public Object doCompute(String expr) {
        this.init(expr);
        return this.dataStack.pop();
    }

    private void init(String expr) {
        StringBuilder dataSb = new StringBuilder();
        int prevQuote = 32;
        char prevChar = ' ';
        for (int i = 0; i < expr.length(); ++i) {
            char c = expr.charAt(i);
            if (prevChar == '\\') {
                dataSb.append(c);
                prevChar = c;
                continue;
            }
            if (prevQuote == 34) {
                if (c == '\"') {
                    prevQuote = 32;
                    this.dataStack.push(dataSb.toString());
                    dataSb.setLength(0);
                } else {
                    dataSb.append(c);
                }
                prevChar = c;
                continue;
            }
            switch (c) {
                case '+': {
                    this.doOp(dataSb, c, prevChar);
                    break;
                }
                case '-': {
                    this.doOp(dataSb, c, prevChar);
                    break;
                }
                case '*': {
                    this.doOp(dataSb, c, prevChar);
                    break;
                }
                case '/': {
                    this.doOp(dataSb, c, prevChar);
                    break;
                }
                case '%': {
                    this.doOp(dataSb, c, prevChar);
                    break;
                }
                case '(': {
                    this.operateStack.push(Character.valueOf(c));
                    break;
                }
                case ')': {
                    this.addDataStack(dataSb);
                    this.doCalculate(1);
                    break;
                }
                case '\"': {
                    if (prevQuote == 34) {
                        prevQuote = 32;
                        this.dataStack.push(dataSb.toString());
                        dataSb.setLength(0);
                        break;
                    }
                    prevQuote = 34;
                    break;
                }
                case ' ': {
                    if (prevQuote != 34) break;
                    dataSb.append(c);
                    break;
                }
                default: {
                    dataSb.append(c);
                }
            }
            prevChar = c;
        }
        if (dataSb.length() > 0) {
            this.addDataStack(dataSb);
        }
        this.doCalculate(0);
    }

    private void doOp(StringBuilder dataSb, char op, char prevChar) {
        if (dataSb.length() == 0 && prevChar != ')' && prevChar != '\"') {
            dataSb.append(op);
        } else {
            this.addDataStack(dataSb);
            if (op == '+' || op == '-') {
                this.doCalculate(0);
            } else {
                this.doCalculate(2);
            }
            this.operateStack.push(Character.valueOf(op));
        }
    }

    private void doCalculate(int current) {
        if (this.operateStack.empty()) {
            return;
        }
        char prevOp = this.operateStack.peek().charValue();
        if (prevOp == '(') {
            this.operateStack.pop();
            return;
        }
        if (current == 0 || current == 1) {
            char op = this.operateStack.pop().charValue();
            do {
                Object right = this.dataStack.pop();
                Object left = this.dataStack.pop();
                Object result = this.calculate(left, op, right);
                this.dataStack.push(result);
            } while (!this.operateStack.isEmpty() && (op = this.operateStack.pop().charValue()) != '(');
        } else if (current == 2) {
            while (prevOp == '*' || prevOp == '/' || prevOp == '%') {
                Object right = this.dataStack.pop();
                Object left = this.dataStack.pop();
                char op = this.operateStack.pop().charValue();
                Object result = this.calculate(left, op, right);
                this.dataStack.push(result);
                if (!this.operateStack.isEmpty() && (prevOp = this.operateStack.peek().charValue()) != '(') continue;
                break;
            }
        }
    }

    private Object calculate(Object left, char op, Object right) {
        if (op == '*' || op == '/' || op == '%' || op == '-') {
            if (right instanceof String || left instanceof String) {
                return left.toString() + op + right.toString();
            }
            BigDecimal b1 = (BigDecimal)left;
            BigDecimal b2 = (BigDecimal)right;
            if (op == '*') {
                return b1.multiply(b2);
            }
            if (op == '/') {
                return b1.divide(b2, 10, RoundingMode.HALF_UP).stripTrailingZeros();
            }
            if (op == '%') {
                return b1.divideAndRemainder(b2)[1];
            }
            if (op == '-') {
                return b1.subtract(b2);
            }
        } else if (op == '+') {
            if (right instanceof String || left instanceof String) {
                return left.toString() + right.toString();
            }
            BigDecimal b1 = (BigDecimal)left;
            BigDecimal b2 = (BigDecimal)right;
            return b1.add(b2);
        }
        throw new RuntimeException("Unkown operate " + op + "");
    }

    private void addDataStack(StringBuilder dataSb) {
        if (dataSb.length() == 0) {
            return;
        }
        String data = dataSb.toString();
        dataSb.setLength(0);
        try {
            BigDecimal bd = Utils.toBigDecimal(data);
            this.dataStack.push(bd);
        }
        catch (Exception ex) {
            this.dataStack.push(data);
        }
    }
}

