/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.parser.impl;

import com.bstek.ureport.definition.ConditionCellStyle;
import com.bstek.ureport.definition.ConditionPaging;
import com.bstek.ureport.definition.ConditionPropertyItem;
import com.bstek.ureport.definition.LinkParameter;
import com.bstek.ureport.expression.ExpressionUtils;
import com.bstek.ureport.expression.model.Condition;
import com.bstek.ureport.expression.model.Expression;
import com.bstek.ureport.expression.model.Op;
import com.bstek.ureport.expression.model.condition.BaseCondition;
import com.bstek.ureport.expression.model.condition.BothExpressionCondition;
import com.bstek.ureport.expression.model.condition.Join;
import com.bstek.ureport.expression.model.condition.PropertyExpressionCondition;
import com.bstek.ureport.parser.Parser;
import com.bstek.ureport.parser.impl.CellStyleParser;
import com.bstek.ureport.parser.impl.ConditionPagingParser;
import com.bstek.ureport.parser.impl.LinkParameterParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;

public class ConditionParameterItemParser
implements Parser<ConditionPropertyItem> {
    private Map<String, Parser<?>> parsers = new HashMap();

    public ConditionParameterItemParser() {
        this.parsers.put("cell-style", new CellStyleParser());
        this.parsers.put("link-parameter", new LinkParameterParser());
        this.parsers.put("paging", new ConditionPagingParser());
    }

    @Override
    public ConditionPropertyItem parse(Element element) {
        String colWidth;
        ConditionPropertyItem item = new ConditionPropertyItem();
        String rowHeight = element.attributeValue("row-height");
        if (StringUtils.isNotBlank((CharSequence)rowHeight)) {
            item.setRowHeight(Integer.valueOf(rowHeight));
        }
        if (StringUtils.isNotBlank((CharSequence)(colWidth = element.attributeValue("col-width")))) {
            item.setColWidth(Integer.valueOf(colWidth));
        }
        item.setName(element.attributeValue("name"));
        item.setNewValue(element.attributeValue("new-value"));
        item.setLinkUrl(element.attributeValue("link-url"));
        item.setLinkTargetWindow(element.attributeValue("link-target-window"));
        ArrayList<LinkParameter> parameters = null;
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        item.setConditions(conditions);
        BaseCondition topCondition = null;
        BaseCondition prevCondition = null;
        for (Object obj : element.elements()) {
            if (obj == null || !(obj instanceof Element)) continue;
            Element ele = (Element)obj;
            String name = ele.getName();
            if (name.equals("condition")) {
                BaseCondition condition = this.parseCondition(ele);
                conditions.add(condition);
                if (topCondition == null) {
                    topCondition = condition;
                    prevCondition = condition;
                    continue;
                }
                prevCondition.setNextCondition(condition);
                prevCondition.setJoin(condition.getJoin());
                prevCondition = condition;
                continue;
            }
            Parser<?> parser = this.parsers.get(name);
            if (parser == null) continue;
            Object data = parser.parse(ele);
            if (data instanceof ConditionCellStyle) {
                item.setCellStyle((ConditionCellStyle)data);
                continue;
            }
            if (data instanceof LinkParameter) {
                if (parameters == null) {
                    parameters = new ArrayList<LinkParameter>();
                }
                parameters.add((LinkParameter)data);
                continue;
            }
            if (!(data instanceof ConditionPaging)) continue;
            item.setPaging((ConditionPaging)data);
        }
        item.setCondition(topCondition);
        item.setLinkParameters(parameters);
        return item;
    }

    private BaseCondition parseCondition(Element ele) {
        String type = ele.attributeValue("type");
        if (type == null || type.equals("property")) {
            String join;
            PropertyExpressionCondition condition = new PropertyExpressionCondition();
            String property = ele.attributeValue("property");
            condition.setLeftProperty(property);
            condition.setLeft(property);
            String operation = ele.attributeValue("op");
            condition.setOperation(operation);
            condition.setOp(Op.parse(operation));
            for (Object o : ele.elements()) {
                Element e;
                if (o == null || !(o instanceof Element) || !(e = (Element)o).getName().equals("value")) continue;
                String expr = e.getTextTrim();
                condition.setRightExpression(ExpressionUtils.parseExpression(expr));
                condition.setRight(expr);
                break;
            }
            if (StringUtils.isNotBlank((CharSequence)(join = ele.attributeValue("join")))) {
                condition.setJoin(Join.valueOf(join));
            }
            return condition;
        }
        BothExpressionCondition exprCondition = new BothExpressionCondition();
        exprCondition.setOp(Op.parse(ele.attributeValue("op")));
        for (Object o : ele.elements()) {
            if (o == null || !(o instanceof Element)) continue;
            Element e = (Element)o;
            String name = e.getName();
            if (name.equals("left")) {
                String left = e.getText();
                Expression leftExpr = ExpressionUtils.parseExpression(left);
                exprCondition.setLeft(left);
                exprCondition.setLeftExpression(leftExpr);
                continue;
            }
            if (!name.equals("right")) continue;
            String right = e.getText();
            Expression rightExpr = ExpressionUtils.parseExpression(right);
            exprCondition.setRight(right);
            exprCondition.setRightExpression(rightExpr);
        }
        String join = ele.attributeValue("join");
        if (StringUtils.isNotBlank((CharSequence)join)) {
            exprCondition.setJoin(Join.valueOf(join));
        }
        return exprCondition;
    }
}

