/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.parser.impl;

import com.bstek.ureport.definition.CellDefinition;
import com.bstek.ureport.definition.CellStyle;
import com.bstek.ureport.definition.ConditionPropertyItem;
import com.bstek.ureport.definition.Expand;
import com.bstek.ureport.definition.LinkParameter;
import com.bstek.ureport.definition.value.Value;
import com.bstek.ureport.exception.ReportException;
import com.bstek.ureport.exception.ReportParseException;
import com.bstek.ureport.expression.ExpressionUtils;
import com.bstek.ureport.expression.model.Expression;
import com.bstek.ureport.parser.Parser;
import com.bstek.ureport.parser.impl.CellStyleParser;
import com.bstek.ureport.parser.impl.ConditionParameterItemParser;
import com.bstek.ureport.parser.impl.LinkParameterParser;
import com.bstek.ureport.parser.impl.value.ChartValueParser;
import com.bstek.ureport.parser.impl.value.DatasetValueParser;
import com.bstek.ureport.parser.impl.value.ExpressionValueParser;
import com.bstek.ureport.parser.impl.value.ImageValueParser;
import com.bstek.ureport.parser.impl.value.SimpleValueParser;
import com.bstek.ureport.parser.impl.value.SlashValueParser;
import com.bstek.ureport.parser.impl.value.ZxingValueParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;

public class CellParser
implements Parser<CellDefinition> {
    private Map<String, Parser<?>> parsers = new HashMap();

    public CellParser() {
        this.parsers.put("simple-value", new SimpleValueParser());
        this.parsers.put("image-value", new ImageValueParser());
        this.parsers.put("expression-value", new ExpressionValueParser());
        this.parsers.put("dataset-value", new DatasetValueParser());
        this.parsers.put("slash-value", new SlashValueParser());
        this.parsers.put("zxing-value", new ZxingValueParser());
        this.parsers.put("chart-value", new ChartValueParser());
        this.parsers.put("cell-style", new CellStyleParser());
        this.parsers.put("link-parameter", new LinkParameterParser());
        this.parsers.put("condition-property-item", new ConditionParameterItemParser());
    }

    @Override
    public CellDefinition parse(Element element) {
        String fillBlankRows;
        String expand;
        String colSpan;
        CellDefinition cell = new CellDefinition();
        cell.setName(element.attributeValue("name"));
        cell.setColumnNumber(Integer.valueOf(element.attributeValue("col")));
        cell.setRowNumber(Integer.valueOf(element.attributeValue("row")));
        cell.setLeftParentCellName(element.attributeValue("left-cell"));
        cell.setTopParentCellName(element.attributeValue("top-cell"));
        String rowSpan = element.attributeValue("row-span");
        if (StringUtils.isNotBlank((CharSequence)rowSpan)) {
            cell.setRowSpan(Integer.valueOf(rowSpan));
        }
        if (StringUtils.isNotBlank((CharSequence)(colSpan = element.attributeValue("col-span")))) {
            cell.setColSpan(Integer.valueOf(colSpan));
        }
        if (StringUtils.isNotBlank((CharSequence)(expand = element.attributeValue("expand")))) {
            cell.setExpand(Expand.valueOf(expand));
        }
        if (StringUtils.isNotBlank((CharSequence)(fillBlankRows = element.attributeValue("fill-blank-rows")))) {
            cell.setFillBlankRows(Boolean.valueOf(fillBlankRows));
            String multiple = element.attributeValue("multiple");
            if (StringUtils.isNotBlank((CharSequence)multiple)) {
                cell.setMultiple(Integer.valueOf(multiple));
            }
        }
        cell.setLinkTargetWindow(element.attributeValue("link-target-window"));
        String linkUrl = element.attributeValue("link-url");
        cell.setLinkUrl(linkUrl);
        if (StringUtils.isNotBlank((CharSequence)linkUrl) && linkUrl.startsWith("${") && linkUrl.endsWith("}")) {
            String expr = linkUrl.substring(2, linkUrl.length() - 1);
            Expression urlExpression = ExpressionUtils.parseExpression(expr);
            cell.setLinkUrlExpression(urlExpression);
        }
        ArrayList<LinkParameter> linkParameters = null;
        ArrayList<ConditionPropertyItem> conditionPropertyItems = null;
        for (Object obj : element.elements()) {
            if (!(obj instanceof Element)) continue;
            Element ele = (Element)obj;
            Object parseData = this.parseValue(ele);
            if (parseData instanceof Value) {
                Value value = (Value)parseData;
                cell.setValue(value);
                continue;
            }
            if (parseData instanceof CellStyle) {
                CellStyle cellStyle = (CellStyle)parseData;
                cell.setCellStyle(cellStyle);
                continue;
            }
            if (parseData instanceof LinkParameter) {
                if (linkParameters == null) {
                    linkParameters = new ArrayList<LinkParameter>();
                }
                linkParameters.add((LinkParameter)parseData);
                continue;
            }
            if (!(parseData instanceof ConditionPropertyItem)) continue;
            if (conditionPropertyItems == null) {
                conditionPropertyItems = new ArrayList<ConditionPropertyItem>();
            }
            conditionPropertyItems.add((ConditionPropertyItem)parseData);
        }
        if (linkParameters != null) {
            cell.setLinkParameters(linkParameters);
        }
        cell.setConditionPropertyItems(conditionPropertyItems);
        if (cell.getValue() == null) {
            throw new ReportException("Cell [" + cell.getName() + "] value not define.");
        }
        return cell;
    }

    private Object parseValue(Element element) {
        Parser<?> parser = this.parsers.get(element.getName());
        if (parser != null) {
            return parser.parse(element);
        }
        throw new ReportParseException("Unknow element :" + element.getName());
    }
}

