/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.image;

import com.bstek.ureport.Utils;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.image.ImageProcessor;
import com.bstek.ureport.provider.image.ImageProvider;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.logging.Logger;
import org.springframework.context.ApplicationContext;

public class StaticImageProcessor
implements ImageProcessor<String> {
    private Logger log = Logger.getGlobal();

    @Override
    public InputStream getImage(String path) {
        Collection<ImageProvider> imageProviders = Utils.getImageProviders();
        ImageProvider targetImageProvider = null;
        for (ImageProvider provider : imageProviders) {
            if (!provider.support(path)) continue;
            targetImageProvider = provider;
            break;
        }
        if (targetImageProvider == null) {
            throw new ReportComputeException("Unsupport image path :" + path);
        }
        try {
            InputStream inputStream = targetImageProvider.getImage(path);
            return inputStream;
        }
        catch (Exception ex) {
            ApplicationContext applicationContext = Utils.getApplicationContext();
            this.log.warning("Image [" + path + "] not exist,use default picture.");
            String imageNotExistPath = "classpath:com/bstek/ureport/image/image-not-exist.jpg";
            try {
                return applicationContext.getResource(imageNotExistPath).getInputStream();
            }
            catch (IOException e1) {
                throw new ReportComputeException(e1);
            }
        }
    }
}

