/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.parse.builder;

import com.bstek.ureport.definition.Order;
import com.bstek.ureport.definition.value.AggregateType;
import com.bstek.ureport.dsl.ReportParserParser;
import com.bstek.ureport.expression.model.condition.BaseCondition;
import com.bstek.ureport.expression.model.expr.BaseExpression;
import com.bstek.ureport.expression.model.expr.dataset.DatasetExpression;
import com.bstek.ureport.expression.parse.builder.BaseExpressionBuilder;
import org.antlr.v4.runtime.tree.TerminalNode;

public class DatasetExpressionBuilder
extends BaseExpressionBuilder {
    @Override
    public BaseExpression build(ReportParserParser.UnitContext unitContext) {
        TerminalNode orderNode;
        ReportParserParser.ConditionsContext conditionsContext;
        ReportParserParser.DatasetContext context = unitContext.dataset();
        DatasetExpression expr = new DatasetExpression();
        expr.setExpr(context.getText());
        expr.setDatasetName(context.Identifier().getText());
        expr.setAggregate(AggregateType.valueOf(context.aggregate().getText()));
        if (context.property() != null) {
            expr.setProperty(context.property().getText());
        }
        if ((conditionsContext = context.conditions()) != null) {
            BaseCondition condition = this.buildConditions(conditionsContext);
            expr.setCondition(condition);
        }
        if ((orderNode = context.ORDER()) != null) {
            expr.setOrder(Order.valueOf(orderNode.getText()));
        }
        return expr;
    }

    @Override
    public boolean support(ReportParserParser.UnitContext unitContext) {
        return unitContext.dataset() != null;
    }
}

