/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.parse;

import com.bstek.ureport.dsl.ReportParserBaseVisitor;
import com.bstek.ureport.dsl.ReportParserParser;
import com.bstek.ureport.exception.ReportParseException;
import com.bstek.ureport.expression.model.Expression;
import com.bstek.ureport.expression.model.Op;
import com.bstek.ureport.expression.model.Operator;
import com.bstek.ureport.expression.model.condition.Join;
import com.bstek.ureport.expression.model.expr.BaseExpression;
import com.bstek.ureport.expression.model.expr.ExpressionBlock;
import com.bstek.ureport.expression.model.expr.JoinExpression;
import com.bstek.ureport.expression.model.expr.ParenExpression;
import com.bstek.ureport.expression.model.expr.VariableAssignExpression;
import com.bstek.ureport.expression.model.expr.ifelse.ElseExpression;
import com.bstek.ureport.expression.model.expr.ifelse.ElseIfExpression;
import com.bstek.ureport.expression.model.expr.ifelse.ExpressionCondition;
import com.bstek.ureport.expression.model.expr.ifelse.ExpressionConditionList;
import com.bstek.ureport.expression.model.expr.ifelse.IfExpression;
import com.bstek.ureport.expression.parse.builder.ExpressionBuilder;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.tree.TerminalNode;

public class ExpressionVisitor
extends ReportParserBaseVisitor<Expression> {
    private List<ExpressionBuilder> expressionBuilders;

    public ExpressionVisitor(List<ExpressionBuilder> expressionBuilders) {
        this.expressionBuilders = expressionBuilders;
    }

    @Override
    public Expression visitEntry(ReportParserParser.EntryContext ctx) {
        StringBuilder sb = new StringBuilder();
        List<ReportParserParser.ExpressionContext> exprs = ctx.expression();
        ArrayList<Expression> list = new ArrayList<Expression>();
        for (ReportParserParser.ExpressionContext exprContext : exprs) {
            sb.append(exprContext.getText());
            Expression expr = this.visitExpression(exprContext);
            list.add(expr);
        }
        ExpressionBlock block = new ExpressionBlock();
        block.setExpressionList(list);
        block.setExpr(sb.toString());
        return block;
    }

    @Override
    public Expression visitExpression(ReportParserParser.ExpressionContext ctx) {
        ReportParserParser.ExprCompositeContext exprCompositeContext = ctx.exprComposite();
        ReportParserParser.IfExprContext ifExprContext = ctx.ifExpr();
        ReportParserParser.CaseExprContext caseExprContext = ctx.caseExpr();
        ReportParserParser.VariableAssignContext assignCtx = ctx.variableAssign();
        ReportParserParser.ReturnExprContext returnCtx = ctx.returnExpr();
        if (exprCompositeContext != null) {
            return this.parseExprComposite(exprCompositeContext);
        }
        if (ifExprContext != null) {
            IfExpression expr = this.parseIfExprContext(ifExprContext);
            return expr;
        }
        if (caseExprContext != null) {
            IfExpression expr = this.parseCaseExprContext(caseExprContext);
            return expr;
        }
        if (assignCtx != null) {
            VariableAssignExpression expr = new VariableAssignExpression();
            expr.setExpr(assignCtx.getText());
            expr.setVariable(assignCtx.variable().Identifier().getText());
            expr.setExpression(this.parseItemContext(assignCtx.item()));
            return expr;
        }
        if (returnCtx != null) {
            return (Expression)this.visitExpr(returnCtx.expr());
        }
        throw new ReportParseException("Expression [" + ctx.getText() + "] is invalid.");
    }

    private Expression parseExprComposite(ReportParserParser.ExprCompositeContext exprCompositeContext) {
        if (exprCompositeContext instanceof ReportParserParser.SingleExprCompositeContext) {
            ReportParserParser.SingleExprCompositeContext singleExprCompositeContext = (ReportParserParser.SingleExprCompositeContext)exprCompositeContext;
            ReportParserParser.ExprContext exprContext = singleExprCompositeContext.expr();
            return this.parseExpr(exprContext);
        }
        if (exprCompositeContext instanceof ReportParserParser.ParenExprCompositeContext) {
            ReportParserParser.ParenExprCompositeContext parenExprCompositeContext = (ReportParserParser.ParenExprCompositeContext)exprCompositeContext;
            ReportParserParser.ExprCompositeContext childExprCompositeContext = parenExprCompositeContext.exprComposite();
            return this.parseExprComposite(childExprCompositeContext);
        }
        if (exprCompositeContext instanceof ReportParserParser.TernaryExprCompositeContext) {
            ReportParserParser.TernaryExprCompositeContext ternaryExprCompositeContext = (ReportParserParser.TernaryExprCompositeContext)exprCompositeContext;
            ReportParserParser.TernaryExprContext ternaryExprContext = ternaryExprCompositeContext.ternaryExpr();
            List<ReportParserParser.IfConditionContext> ifConditionContexts = ternaryExprContext.ifCondition();
            IfExpression expr = new IfExpression();
            expr.setConditionList(this.parseCondtionList(ifConditionContexts, ternaryExprContext.join()));
            ReportParserParser.BlockContext firstBlockContext = ternaryExprContext.block(0);
            expr.setExpression(this.parseBlock(firstBlockContext));
            ReportParserParser.BlockContext secondBlockContext = ternaryExprContext.block(1);
            ElseExpression elseExpr = new ElseExpression();
            elseExpr.setExpression(this.parseBlock(secondBlockContext));
            expr.setElseExpression(elseExpr);
            return expr;
        }
        if (exprCompositeContext instanceof ReportParserParser.ComplexExprCompositeContext) {
            ReportParserParser.ComplexExprCompositeContext complexExprCompositeContext = (ReportParserParser.ComplexExprCompositeContext)exprCompositeContext;
            ReportParserParser.ExprCompositeContext leftExprCompositeContext = complexExprCompositeContext.exprComposite(0);
            Expression leftExpression = this.parseExprComposite(leftExprCompositeContext);
            ReportParserParser.ExprCompositeContext rightExprCompositeContext = complexExprCompositeContext.exprComposite(1);
            Expression rightExpression = this.parseExprComposite(rightExprCompositeContext);
            String op = complexExprCompositeContext.Operator().getText();
            Operator operator = Operator.parse(op);
            ArrayList<BaseExpression> expressions = new ArrayList<BaseExpression>();
            expressions.add((BaseExpression)leftExpression);
            expressions.add((BaseExpression)rightExpression);
            ArrayList<Operator> operators = new ArrayList<Operator>();
            operators.add(operator);
            ParenExpression expression = new ParenExpression(operators, expressions);
            expression.setExpr(complexExprCompositeContext.getText());
            return expression;
        }
        throw new ReportParseException("Unknow context :" + (Object)((Object)exprCompositeContext));
    }

    private ExpressionBlock parseExpressionBlock(List<ReportParserParser.ExprBlockContext> contexts) {
        StringBuilder sb = new StringBuilder();
        ArrayList<Expression> expressionList = new ArrayList<Expression>();
        for (ReportParserParser.ExprBlockContext ctx : contexts) {
            ReportParserParser.CaseExprContext caseCtx;
            ReportParserParser.IfExprContext ifCtx;
            sb.append(ctx.getText());
            ReportParserParser.VariableAssignContext assignContext = ctx.variableAssign();
            if (assignContext != null) {
                ReportParserParser.VariableContext varCtx = assignContext.variable();
                String variableName = varCtx.Identifier().getText();
                VariableAssignExpression assignExpr = new VariableAssignExpression();
                assignExpr.setExpr(assignContext.getText());
                assignExpr.setVariable(variableName);
                ReportParserParser.ItemContext itemCtx = assignContext.item();
                BaseExpression itemExpr = this.parseItemContext(itemCtx);
                assignExpr.setExpression(itemExpr);
                expressionList.add(assignExpr);
            }
            if ((ifCtx = ctx.ifExpr()) != null) {
                IfExpression ifExpr = this.parseIfExprContext(ifCtx);
                expressionList.add(ifExpr);
            }
            if ((caseCtx = ctx.caseExpr()) == null) continue;
            IfExpression caseExpr = this.parseCaseExprContext(caseCtx);
            expressionList.add(caseExpr);
        }
        ExpressionBlock blockExpr = new ExpressionBlock();
        blockExpr.setExpressionList(expressionList);
        blockExpr.setExpr(sb.toString());
        return blockExpr;
    }

    private IfExpression parseIfExprContext(ReportParserParser.IfExprContext ifExprContext) {
        ReportParserParser.ElsePartContext elsePartContext;
        IfExpression expr = new IfExpression();
        expr.setExpr(ifExprContext.getText());
        ReportParserParser.IfPartContext ifPartContext = ifExprContext.ifPart();
        List<ReportParserParser.IfConditionContext> ifConditionContexts = ifPartContext.ifCondition();
        List<ReportParserParser.JoinContext> joinContexts = ifPartContext.join();
        expr.setConditionList(this.parseCondtionList(ifConditionContexts, joinContexts));
        ExpressionBlock blockExpr = this.parseBlock(ifPartContext.block());
        expr.setExpression(blockExpr);
        List<ReportParserParser.ElseIfPartContext> elseIfPartContexts = ifExprContext.elseIfPart();
        if (elseIfPartContexts != null && elseIfPartContexts.size() > 0) {
            ArrayList<ElseIfExpression> elseIfExpressionList = new ArrayList<ElseIfExpression>();
            for (ReportParserParser.ElseIfPartContext elseIfContext : elseIfPartContexts) {
                ifConditionContexts = elseIfContext.ifCondition();
                joinContexts = elseIfContext.join();
                ElseIfExpression elseIfExpr = new ElseIfExpression();
                elseIfExpr.setConditionList(this.parseCondtionList(ifConditionContexts, joinContexts));
                elseIfExpr.setExpression(this.parseBlock(elseIfContext.block()));
                elseIfExpressionList.add(elseIfExpr);
            }
            expr.setElseIfExpressions(elseIfExpressionList);
        }
        if ((elsePartContext = ifExprContext.elsePart()) != null) {
            ElseExpression elseExpression = new ElseExpression();
            elseExpression.setExpression(this.parseBlock(elsePartContext.block()));
            expr.setElseExpression(elseExpression);
        }
        return expr;
    }

    private ExpressionBlock parseBlock(ReportParserParser.BlockContext blockCtx) {
        List<ReportParserParser.ExprBlockContext> exprBlockCtxs = blockCtx.exprBlock();
        ReportParserParser.ReturnExprContext returnCtx = blockCtx.returnExpr();
        ExpressionBlock block = null;
        if (exprBlockCtxs != null) {
            block = this.parseExpressionBlock(exprBlockCtxs);
        }
        if (returnCtx != null) {
            if (block == null) {
                block = new ExpressionBlock();
            }
            block.setReturnExpression((Expression)this.visitExpr(returnCtx.expr()));
        }
        return block;
    }

    private IfExpression parseCaseExprContext(ReportParserParser.CaseExprContext caseExprContext) {
        IfExpression expr = new IfExpression();
        ArrayList<ElseIfExpression> elseIfExpressionList = new ArrayList<ElseIfExpression>();
        expr.setElseIfExpressions(elseIfExpressionList);
        List<ReportParserParser.CasePartContext> casePartContexts = caseExprContext.casePart();
        for (ReportParserParser.CasePartContext casePartContext : casePartContexts) {
            List<ReportParserParser.IfConditionContext> ifConditionContexts = casePartContext.ifCondition();
            List<ReportParserParser.JoinContext> joinContexts = casePartContext.join();
            ElseIfExpression elseIfExpr = new ElseIfExpression();
            elseIfExpr.setConditionList(this.parseCondtionList(ifConditionContexts, joinContexts));
            elseIfExpr.setExpr(casePartContext.getText());
            ExpressionBlock blockExpr = this.parseBlock(casePartContext.block());
            elseIfExpr.setExpression(blockExpr);
            elseIfExpressionList.add(elseIfExpr);
        }
        return expr;
    }

    private Expression parseExpr(ReportParserParser.ExprContext exprContext) {
        ArrayList<BaseExpression> expressions = new ArrayList<BaseExpression>();
        ArrayList<Operator> operators = new ArrayList<Operator>();
        List<ReportParserParser.ItemContext> itemContexts = exprContext.item();
        List<TerminalNode> operatorNodes = exprContext.Operator();
        for (int i = 0; i < itemContexts.size(); ++i) {
            ReportParserParser.ItemContext itemContext = itemContexts.get(i);
            BaseExpression expr = this.parseItemContext(itemContext);
            expressions.add(expr);
            if (i <= 0) continue;
            TerminalNode operatorNode = operatorNodes.get(i - 1);
            String op = operatorNode.getText();
            operators.add(Operator.parse(op));
        }
        ParenExpression expression = new ParenExpression(operators, expressions);
        expression.setExpr(exprContext.getText());
        return expression;
    }

    private ExpressionConditionList parseCondtionList(List<ReportParserParser.IfConditionContext> ifConditionContexts, List<ReportParserParser.JoinContext> joinContexts) {
        ArrayList<ExpressionCondition> list = new ArrayList<ExpressionCondition>();
        ArrayList<Join> joins = new ArrayList<Join>();
        for (int i = 0; i < ifConditionContexts.size(); ++i) {
            ReportParserParser.IfConditionContext context = ifConditionContexts.get(i);
            ReportParserParser.ExprContext left = context.expr(0);
            ReportParserParser.ExprContext right = context.expr(1);
            Expression leftExpr = this.parseExpr(left);
            Expression rightExpr = this.parseExpr(right);
            Op op = Op.parse(context.OP().getText());
            ExpressionCondition condition = new ExpressionCondition(leftExpr, op, rightExpr);
            list.add(condition);
            if (i <= 0) continue;
            ReportParserParser.JoinContext joinContext = joinContexts.get(i - 1);
            String text = joinContext.getText();
            Join join = Join.and;
            if (text.equals("or") || text.equals("||")) {
                join = Join.or;
            }
            joins.add(join);
        }
        return new ExpressionConditionList(list, joins);
    }

    public BaseExpression parseItemContext(ReportParserParser.ItemContext itemContext) {
        BaseExpression expression = null;
        if (itemContext instanceof ReportParserParser.SimpleJoinContext) {
            ReportParserParser.SimpleJoinContext simpleJoinContext = (ReportParserParser.SimpleJoinContext)itemContext;
            expression = this.visitSimpleJoin(simpleJoinContext);
        } else if (itemContext instanceof ReportParserParser.ParenJoinContext) {
            ReportParserParser.ParenJoinContext parenJoinContext = (ReportParserParser.ParenJoinContext)itemContext;
            expression = this.visitParenJoin(parenJoinContext);
        } else if (itemContext instanceof ReportParserParser.SingleParenJoinContext) {
            ReportParserParser.SingleParenJoinContext singleContext = (ReportParserParser.SingleParenJoinContext)itemContext;
            ReportParserParser.ItemContext childItemContext = singleContext.item();
            expression = this.parseItemContext(childItemContext);
        } else {
            throw new ReportParseException("Unknow context :" + (Object)((Object)itemContext));
        }
        return expression;
    }

    @Override
    public BaseExpression visitSimpleJoin(ReportParserParser.SimpleJoinContext ctx) {
        ArrayList<BaseExpression> expressions = new ArrayList<BaseExpression>();
        ArrayList<Operator> operators = new ArrayList<Operator>();
        List<ReportParserParser.UnitContext> unitContexts = ctx.unit();
        List<TerminalNode> operatorNodes = ctx.Operator();
        for (int i = 0; i < unitContexts.size(); ++i) {
            ReportParserParser.UnitContext unitContext = unitContexts.get(i);
            BaseExpression expr = this.buildExpression(unitContext);
            expressions.add(expr);
            if (i <= 0) continue;
            TerminalNode operatorNode = operatorNodes.get(i - 1);
            String op = operatorNode.getText();
            operators.add(Operator.parse(op));
        }
        if (operators.size() == 0 && expressions.size() == 1) {
            return (BaseExpression)expressions.get(0);
        }
        JoinExpression expression = new JoinExpression(operators, expressions);
        expression.setExpr(ctx.getText());
        return expression;
    }

    @Override
    public BaseExpression visitParenJoin(ReportParserParser.ParenJoinContext ctx) {
        ArrayList<BaseExpression> expressions = new ArrayList<BaseExpression>();
        ArrayList<Operator> operators = new ArrayList<Operator>();
        List<ReportParserParser.ItemContext> itemContexts = ctx.item();
        List<TerminalNode> operatorNodes = ctx.Operator();
        for (int i = 0; i < itemContexts.size(); ++i) {
            ReportParserParser.ItemContext itemContext = itemContexts.get(i);
            BaseExpression expr = this.parseItemContext(itemContext);
            expressions.add(expr);
            if (i <= 0) continue;
            TerminalNode operatorNode = operatorNodes.get(i - 1);
            String op = operatorNode.getText();
            operators.add(Operator.parse(op));
        }
        ParenExpression expression = new ParenExpression(operators, expressions);
        expression.setExpr(ctx.getText());
        return expression;
    }

    private BaseExpression buildExpression(ReportParserParser.UnitContext unitContext) {
        for (ExpressionBuilder builder : this.expressionBuilders) {
            if (!builder.support(unitContext)) continue;
            return builder.build(unitContext);
        }
        throw new ReportParseException("Unknow context :" + (Object)((Object)unitContext));
    }
}

