/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.model.expr;

import com.bstek.ureport.build.BindData;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.expression.model.Expression;
import com.bstek.ureport.expression.model.data.BindDataListExpressionData;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.expression.model.data.ObjectExpressionData;
import com.bstek.ureport.expression.model.data.ObjectListExpressionData;
import com.bstek.ureport.expression.model.expr.BaseExpression;
import com.bstek.ureport.model.Cell;
import java.util.Iterator;

public class VariableAssignExpression
extends BaseExpression {
    private static final long serialVersionUID = 435511939569866187L;
    private String variable;
    private Expression expression;

    @Override
    protected ExpressionData<?> compute(Cell cell, Cell currentCell, Context context) {
        ExpressionData<?> data = this.expression.execute(cell, currentCell, context);
        Object obj = null;
        if (data instanceof ObjectExpressionData) {
            ObjectExpressionData d = (ObjectExpressionData)data;
            obj = d.getData();
        } else if (data instanceof ObjectListExpressionData) {
            ObjectListExpressionData d = (ObjectListExpressionData)data;
            obj = d.getData();
        } else if (data instanceof BindDataListExpressionData) {
            BindDataListExpressionData dataList = (BindDataListExpressionData)data;
            Object bindList = dataList.getData();
            if (bindList.size() == 1) {
                BindData bindData = (BindData)bindList.get(0);
                obj = bindData.getValue();
            } else {
                StringBuilder sb = new StringBuilder();
                Iterator iterator = bindList.iterator();
                while (iterator.hasNext()) {
                    BindData bd = (BindData)iterator.next();
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(bd.getValue());
                }
                obj = sb.toString();
            }
        }
        if (obj != null) {
            context.putVariable(this.variable, obj);
        }
        return null;
    }

    public String getVariable() {
        return this.variable;
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }
}

