/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.model.expr;

import com.bstek.ureport.build.Context;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.expression.model.data.ObjectExpressionData;
import com.bstek.ureport.expression.model.expr.set.CellExpression;
import com.bstek.ureport.model.Cell;
import java.util.List;
import java.util.Map;

public class CellPositionExpression
extends CellExpression {
    private static final long serialVersionUID = 6881039873078990276L;

    public CellPositionExpression(String cellName) {
        super(cellName);
    }

    @Override
    public boolean supportPaging() {
        return false;
    }

    @Override
    protected ExpressionData<?> compute(Cell cell, Cell currentCell, Context context) {
        Cell target;
        int i;
        List<Cell> targetCells = this.fetchCellsByLeftParent(context, cell, this.cellName);
        if (targetCells == null || targetCells.size() == 0) {
            targetCells = this.fetchCellsByTopParent(context, cell, this.cellName);
        }
        if (targetCells == null || targetCells.size() == 0) {
            targetCells = context.getReport().getCellsMap().get(this.cellName);
        }
        if (targetCells == null) {
            throw new ReportComputeException("Cell [" + this.cellName + "] not exist.");
        }
        int index = -1;
        int rowNumber = cell.getRow().getRowNumber();
        int colNumber = cell.getColumn().getColumnNumber();
        for (i = 0; i < targetCells.size(); ++i) {
            target = targetCells.get(i);
            if (target.getRow() == cell.getRow()) {
                index = i;
                break;
            }
            int rowSpan = target.getRowSpan();
            if (rowSpan <= 0) continue;
            int targetRowStart = target.getRow().getRowNumber();
            int targetRowEnd = targetRowStart + rowSpan - 1;
            if (targetRowStart > rowNumber || targetRowEnd < rowNumber) continue;
            index = i;
            break;
        }
        if (index > -1) {
            return new ObjectExpressionData(++index);
        }
        for (i = 0; i < targetCells.size(); ++i) {
            target = targetCells.get(i);
            if (target.getColumn() == cell.getColumn()) {
                index = i;
                break;
            }
            int colSpan = target.getColSpan();
            if (colSpan <= 0) continue;
            int targetColStart = target.getColumn().getColumnNumber();
            int targetColEnd = targetColStart + colSpan - 1;
            if (targetColStart > colNumber || targetColEnd < colNumber) continue;
            index = i;
            break;
        }
        return new ObjectExpressionData(++index);
    }

    private List<Cell> fetchCellsByLeftParent(Context context, Cell cell, String cellName) {
        Cell leftParentCell = cell.getLeftParentCell();
        if (leftParentCell == null) {
            return null;
        }
        Map<String, List<Cell>> childrenCellsMap = leftParentCell.getRowChildrenCellsMap();
        List<Cell> targetCells = childrenCellsMap.get(cellName);
        if (targetCells != null) {
            return targetCells;
        }
        return this.fetchCellsByLeftParent(context, leftParentCell, cellName);
    }

    private List<Cell> fetchCellsByTopParent(Context context, Cell cell, String cellName) {
        Cell topParentCell = cell.getTopParentCell();
        if (topParentCell == null) {
            return null;
        }
        Map<String, List<Cell>> childrenCellsMap = topParentCell.getColumnChildrenCellsMap();
        List<Cell> targetCells = childrenCellsMap.get(cellName);
        if (targetCells != null) {
            return targetCells;
        }
        return this.fetchCellsByTopParent(context, topParentCell, cellName);
    }
}

