/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.function.string;

import com.bstek.ureport.Utils;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.expression.function.string.StringFunction;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.expression.model.data.ObjectExpressionData;
import com.bstek.ureport.model.Cell;
import java.util.List;

public class SubstringFunction
extends StringFunction {
    @Override
    public Object execute(List<ExpressionData<?>> dataList, Context context, Cell currentCell) {
        ExpressionData<?> exprData;
        String text = this.buildString(dataList);
        int start = 0;
        int end = text.length();
        if (dataList.size() > 1) {
            exprData = dataList.get(1);
            start = this.buildPos(exprData);
        }
        if (dataList.size() == 3) {
            exprData = dataList.get(2);
            end = this.buildPos(exprData);
        }
        return text.substring(start, end);
    }

    private int buildPos(ExpressionData<?> exprData) {
        if (exprData instanceof ObjectExpressionData) {
            ObjectExpressionData objData = (ObjectExpressionData)exprData;
            Object obj = objData.getData();
            if (obj == null) {
                throw new ReportComputeException("Function [" + this.name() + "] second parameter can not be null.");
            }
            return Utils.toBigDecimal(obj).intValue();
        }
        throw new ReportComputeException("Function [" + this.name() + "] position data is invalid : " + exprData);
    }

    @Override
    public String name() {
        return "substring";
    }
}

