/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.function.string;

import com.bstek.ureport.Utils;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.expression.function.string.StringFunction;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.expression.model.data.ObjectExpressionData;
import com.bstek.ureport.model.Cell;
import java.util.List;

public class IndexOfFunction
extends StringFunction {
    @Override
    public Object execute(List<ExpressionData<?>> dataList, Context context, Cell currentCell) {
        ExpressionData<?> exprData;
        String text = this.buildString(dataList);
        String targetText = null;
        if (dataList.size() > 1 && (exprData = dataList.get(1)) instanceof ObjectExpressionData) {
            ObjectExpressionData objData = (ObjectExpressionData)exprData;
            Object obj = objData.getData();
            if (obj == null) {
                throw new ReportComputeException("Function [" + this.name() + "] parameter can not be null.");
            }
            targetText = obj.toString();
        }
        int start = 0;
        if (dataList.size() == 3) {
            ExpressionData<?> exprData2 = dataList.get(2);
            start = this.buildStart(exprData2);
        }
        return text.indexOf(targetText, start);
    }

    private int buildStart(ExpressionData<?> exprData) {
        if (exprData instanceof ObjectExpressionData) {
            ObjectExpressionData objData = (ObjectExpressionData)exprData;
            Object obj = objData.getData();
            if (obj == null) {
                throw new ReportComputeException("Function [" + this.name() + "] parameter can not be null.");
            }
            return Utils.toBigDecimal(obj).intValue();
        }
        throw new ReportComputeException("Function [" + this.name() + "] start position data is invalid : " + exprData);
    }

    @Override
    public String name() {
        return "indexof";
    }
}

