/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.function.date;

import com.bstek.ureport.build.Context;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.expression.function.date.CalendarFunction;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.expression.model.data.ObjectExpressionData;
import com.bstek.ureport.model.Cell;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class DateFunction
extends CalendarFunction {
    private String pattern = "yyyy-MM-dd HH:mm:ss";

    @Override
    public Object execute(List<ExpressionData<?>> dataList, Context context, Cell currentCell) {
        SimpleDateFormat sd = new SimpleDateFormat(this.pattern);
        Date date = new Date();
        if (dataList.size() == 1) {
            ExpressionData<?> data = dataList.get(0);
            sd = this.buildPattern(data);
        }
        if (dataList.size() == 2) {
            Calendar c = this.buildCalendar(dataList);
            date = c.getTime();
            ExpressionData<?> data = dataList.get(1);
            sd = this.buildPattern(data);
        }
        return sd.format(date);
    }

    private SimpleDateFormat buildPattern(ExpressionData<?> data) {
        SimpleDateFormat sd = null;
        if (!(data instanceof ObjectExpressionData)) {
            throw new ReportComputeException("Unknow date format pattern:" + data.getData());
        }
        ObjectExpressionData objectData = (ObjectExpressionData)data;
        String newPattern = (String)objectData.getData();
        sd = new SimpleDateFormat(newPattern);
        return sd;
    }

    @Override
    public String name() {
        return "date";
    }
}

