/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.chart.dataset.impl.category;

import com.bstek.ureport.Utils;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.chart.dataset.BaseDataset;
import com.bstek.ureport.chart.dataset.CollectType;
import com.bstek.ureport.chart.dataset.impl.category.AreaDataset;
import com.bstek.ureport.chart.dataset.impl.category.LineDataset;
import com.bstek.ureport.chart.dataset.impl.category.SeriesType;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.model.Cell;
import com.bstek.ureport.utils.DataUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class CategoryDataset
extends BaseDataset {
    private CollectType collectType = CollectType.select;
    private String datasetName;
    private String categoryProperty;
    private String seriesProperty;
    private String valueProperty;
    private String seriesText;
    private SeriesType seriesType = SeriesType.text;
    private String labels;
    private String format;

    protected String buildDatasetJson(Context context, Cell cell, String props) {
        List<?> dataList = DataUtils.fetchData(cell, context, this.datasetName);
        ArrayList<Object> categoryList = new ArrayList<Object>();
        LinkedHashMap<Object, Map<Object, List<Object>>> seriesDataMap = new LinkedHashMap<Object, Map<Object, List<Object>>>();
        for (Object obj : dataList) {
            Object valueList;
            Map<Object, Object> categoryMap;
            Object value;
            Object category = Utils.getProperty(obj, this.categoryProperty);
            if (category == null) continue;
            if (!categoryList.contains(category)) {
                categoryList.add(category);
            }
            Object series = null;
            series = this.seriesType.equals((Object)SeriesType.property) ? Utils.getProperty(obj, this.seriesProperty) : this.seriesText;
            if (series == null || (value = Utils.getProperty(obj, this.valueProperty)) == null) continue;
            if (seriesDataMap.containsKey(series)) {
                categoryMap = (Map)seriesDataMap.get(series);
                valueList = null;
                if (categoryMap.containsKey(category)) {
                    valueList = (List)categoryMap.get(category);
                } else {
                    valueList = new ArrayList();
                    categoryMap.put(category, valueList);
                }
                valueList.add(value);
                continue;
            }
            categoryMap = new LinkedHashMap();
            seriesDataMap.put(series, categoryMap);
            for (Object e : categoryList) {
                categoryMap.put(e, new ArrayList());
            }
            valueList = (List)categoryMap.get(category);
            valueList.add(value);
        }
        this.setLabels(this.toLabel(categoryList));
        return this.buildDatasets(seriesDataMap, props);
    }

    protected String buildDatasets(Map<Object, Map<Object, List<Object>>> map, String props) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (Object series : map.keySet()) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("{");
            sb.append("\"label\":\"" + series + "\",");
            String color = null;
            color = this instanceof LineDataset ? "rgb(" + this.getRgbColor(i) + ")" : "rgba(" + this.getRgbColor(i) + ",0.3)";
            sb.append("\"backgroundColor\":\"" + color + "\",");
            sb.append("\"borderColor\":\"rgb(" + this.getRgbColor(i) + ")\",");
            sb.append("\"borderWidth\": 1,");
            sb.append("\"data\":" + this.buildData(map.get(series)));
            if (this instanceof LineDataset) {
                sb.append(",");
                if (this instanceof AreaDataset) {
                    sb.append("\"fill\":true");
                } else {
                    sb.append("\"fill\":false");
                }
            }
            if (props != null) {
                sb.append("," + props);
            }
            sb.append("}");
            ++i;
        }
        sb.append("");
        return sb.toString();
    }

    protected String buildData(Map<Object, List<Object>> categoryMap) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (Object category : categoryMap.keySet()) {
            List<Object> list = categoryMap.get(category);
            double data = this.collectData(list);
            if (sb.length() > 1) {
                sb.append(",");
            }
            sb.append(data);
        }
        sb.append("]");
        return sb.toString();
    }

    protected double collectData(List<Object> list) {
        double result = 0.0;
        if (list.size() == 0) {
            return result;
        }
        switch (this.collectType) {
            case select: {
                result = Utils.toBigDecimal(list.get(0)).doubleValue();
                break;
            }
            case avg: {
                double total = 0.0;
                for (Object data : list) {
                    total += Utils.toBigDecimal(data).doubleValue();
                }
                result = Utils.toBigDecimal(total).divide(Utils.toBigDecimal(list.size()), 8, 4).doubleValue();
                break;
            }
            case count: {
                result = list.size();
                break;
            }
            case max: {
                Double max = null;
                for (Object data : list) {
                    double value = Utils.toBigDecimal(data).doubleValue();
                    if (max == null) {
                        max = value;
                        continue;
                    }
                    if (!(max < value)) continue;
                    max = value;
                }
                result = max;
                break;
            }
            case min: {
                Double min = null;
                for (Object data : list) {
                    double value = Utils.toBigDecimal(data).doubleValue();
                    if (min == null) {
                        min = value;
                        continue;
                    }
                    if (!(min > value)) continue;
                    min = value;
                }
                result = min;
                break;
            }
            case sum: {
                for (Object data : list) {
                    double value = Utils.toBigDecimal(data).doubleValue();
                    result += value;
                }
                break;
            }
        }
        return result;
    }

    private String toLabel(List<Object> categoryList) {
        StringBuilder sb = new StringBuilder();
        for (Object obj : categoryList) {
            if (sb.length() > 0) {
                sb.append(",");
            } else {
                sb.append("[");
            }
            if (StringUtils.isNotBlank((CharSequence)this.format)) {
                if (obj instanceof Date) {
                    Date date = (Date)obj;
                    SimpleDateFormat sd = new SimpleDateFormat(this.format);
                    obj = sd.format(date);
                } else {
                    try {
                        BigDecimal data = Utils.toBigDecimal(obj);
                        DecimalFormat df = new DecimalFormat(this.format);
                        obj = df.format(data.doubleValue());
                    }
                    catch (Exception ex) {
                        throw new ReportComputeException("Can not format data [" + obj + "] use pattern [" + this.format + "]");
                    }
                }
            }
            sb.append("\"" + obj + "\"");
        }
        if (sb.length() == 0) {
            sb.append("[");
        }
        sb.append("]");
        return sb.toString();
    }

    public String getSeriesText() {
        return this.seriesText;
    }

    public void setSeriesText(String seriesText) {
        this.seriesText = seriesText;
    }

    public SeriesType getSeriesType() {
        return this.seriesType;
    }

    public void setSeriesType(SeriesType seriesType) {
        this.seriesType = seriesType;
    }

    public CollectType getCollectType() {
        return this.collectType;
    }

    public void setCollectType(CollectType collectType) {
        this.collectType = collectType;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public void setDatasetName(String datasetName) {
        this.datasetName = datasetName;
    }

    public String getCategoryProperty() {
        return this.categoryProperty;
    }

    public void setCategoryProperty(String categoryProperty) {
        this.categoryProperty = categoryProperty;
    }

    public String getSeriesProperty() {
        return this.seriesProperty;
    }

    public void setSeriesProperty(String seriesProperty) {
        this.seriesProperty = seriesProperty;
    }

    public String getValueProperty() {
        return this.valueProperty;
    }

    public void setValueProperty(String valueProperty) {
        this.valueProperty = valueProperty;
    }

    public void setLabels(String labels) {
        this.labels = labels;
    }

    public String getLabels() {
        return this.labels;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }
}

