/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.build.cell.right;

import com.bstek.ureport.build.Context;
import com.bstek.ureport.model.Cell;
import com.bstek.ureport.model.Column;
import com.bstek.ureport.model.Report;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RightDuplicate {
    private int index;
    private int columnSize;
    private Context context;
    private Cell mainCell;
    private int minColNumber = -1;
    private Map<Column, Column> colMap = new HashMap<Column, Column>();
    private List<Column> newColList = new ArrayList<Column>();

    public RightDuplicate(Cell mainCell, int columnSize, Context context) {
        this.mainCell = mainCell;
        this.columnSize = columnSize;
        this.context = context;
    }

    public Column newColumn(Column col, int colNumber) {
        if (this.colMap.containsKey(col)) {
            return this.colMap.get(col);
        }
        Column newCol = col.newColumn();
        colNumber = colNumber + this.columnSize * (this.index - 1) + this.columnSize;
        if (this.minColNumber == -1 || this.minColNumber > colNumber) {
            this.minColNumber = colNumber;
        }
        newCol.setTempColumnNumber(colNumber);
        this.newColList.add(newCol);
        this.colMap.put(col, newCol);
        return newCol;
    }

    public int getColSize() {
        return this.columnSize;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public Context getContext() {
        return this.context;
    }

    public Cell getMainCell() {
        return this.mainCell;
    }

    public void complete() {
        if (this.minColNumber < 1) {
            return;
        }
        Report report = this.context.getReport();
        Collections.sort(this.newColList, new Comparator<Column>(){

            @Override
            public int compare(Column o1, Column o2) {
                return o1.getTempColumnNumber() - o2.getTempColumnNumber();
            }
        });
        report.insertColumns(this.minColNumber, this.newColList);
    }

    public void reset() {
        this.colMap.clear();
    }
}

